/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.Multipunto;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.MappaContratti;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.tariffe.ContrattiEleHelper;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.DestinatariManager;
import biz.elabor.prebilling.services.tariffe.MissingIndiceException;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TariffeBuilder;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.ListMap;

abstract class AbstractDestinatariManager
implements DestinatariManager {
    AbstractDestinatariManager() {
    }

    protected void computeDispatcher(ServiceStatus status, int anno, Month mese, TipoCalcolo tipo, Set<String> podSet, String onlyPod, Map<String, Multipunto> multiPodMap, String codiceReseller, MisureDao misureDao, GiadaDao giadaDao, PrebillingConfiguration configuration, TalkManager talkManager, int annoStart, Month meseStart, int annoRif, Month meseRif, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento onlyTipoTrattamento, boolean bloccoIndice) throws CalendarNotFoundException, MissingIndiceException, InconsistentOptionException {
        ListMap<String, TariffaMultiApplicazione> tariffe = new BasicListMap<String, TariffaMultiApplicazione>();
        this.setTariffe(status, tariffe);
        MappaContratti contratti = ContrattiEleHelper.getContratti(Destinatari.DISPATCHER, anno, mese, onlyPod, multiPodMap, codiceReseller, giadaDao, status);
        TariffeBuilder builder = new TariffeBuilder(anno, mese, tipo, Destinatari.DISPATCHER, podSet, contratti, multiPodMap, misureDao, configuration, talkManager, status, annoStart, meseStart, annoRif, meseRif, scivoloEnabled, scivoloForced, onlyPod, onlyTipoTrattamento, false, bloccoIndice);
        tariffe = builder.buildTariffe();
        this.setTariffe(status, tariffe);
    }

    protected void computeReseller(ServiceStatus status, int anno, Month mese, TipoCalcolo tipo, Set<String> podSet, String onlyPod, Map<String, Multipunto> multiPodMap, String codiceReseller, MisureDao misureDao, GiadaDao giadaDao, PrebillingConfiguration configuration, TalkManager talkManager, int annoStart, Month meseStart, int annoRif, Month meseRif, boolean scivoloEnabled, boolean scivoloForced, TipoTrattamento onlyTipoTrattamento, boolean bloccoIndice) throws CalendarNotFoundException {
        ListMap<String, TariffaMultiApplicazione> tariffe = new BasicListMap<String, TariffaMultiApplicazione>();
        status.setTariffeMedieMensiliReseller(tariffe);
        try {
            MappaContratti contratti = ContrattiEleHelper.getContratti(Destinatari.RESELLER, anno, mese, onlyPod, multiPodMap, codiceReseller, giadaDao, status);
            TariffeBuilder builder = new TariffeBuilder(anno, mese, tipo, Destinatari.RESELLER, podSet, contratti, multiPodMap, misureDao, configuration, talkManager, status, annoStart, meseStart, annoRif, meseRif, scivoloEnabled, scivoloForced, onlyPod, onlyTipoTrattamento, false, bloccoIndice);
            tariffe = builder.buildTariffe();
            status.setTariffeMedieMensiliReseller(tariffe);
        }
        catch (MissingIndiceException builder) {
        }
        catch (InconsistentOptionException exc) {
            status.resetTariffeBatch();
        }
    }

    protected static Map<Date, Map<String, Pdo>> buildRfoMap(List<Pdo> rfoList, ServiceStatus status, TalkManager talkManager) {
        TreeMap<Date, Map<String, Pdo>> rfoMap = new TreeMap<Date, Map<String, Pdo>>();
        for (Pdo rfo : rfoList) {
            AbstractDestinatariManager.add(rfo, rfoMap, status, talkManager);
        }
        return rfoMap;
    }

    private static void add(Pdo rfo, Map<Date, Map<String, Pdo>> mapRfo, ServiceStatus status, TalkManager talkManager) {
        String codicePod = rfo.getCodicePod();
        Date meseCompetenza = AbstractDestinatariManager.getMeseCompetenza(rfo);
        Map<String, Pdo> mapCodiceRfo = mapRfo.get(meseCompetenza);
        if (mapCodiceRfo == null) {
            mapCodiceRfo = new TreeMap<String, Pdo>();
            mapRfo.put(meseCompetenza, mapCodiceRfo);
        }
        if (mapCodiceRfo.containsKey(codicePod)) {
            Message sentence = new Message("get.rfo.strategy", "obsoleto");
            sentence.addParam(codicePod);
            DateFormat dataFormat = StrategyHelper.getDataFormat();
            sentence.addParam(dataFormat.format(meseCompetenza));
            sentence.setCss("alert-danger");
            talkManager.addSentence(sentence);
            String descrizione = talkManager.getMessage(sentence);
            status.addRfoObsoleto(new PdoResult(rfo, ErroriElaborazione.OBSOLETO, descrizione));
        } else {
            mapCodiceRfo.put(codicePod, rfo);
        }
    }

    private static Date getMeseCompetenza(Pdo rfo) {
        RilMese rilMese = rfo.getRilMese();
        int anno = rilMese.getAnno();
        Month mese = rilMese.getMese();
        return CalendarTools.getDate(anno, mese, 1);
    }
}

