/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.SofResult;
import biz.elabor.prebilling.model.statopod.AbstractBasicStatoPod;
import biz.elabor.prebilling.model.statopod.AbstractNoncommercialeStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.model.statopod.SnfStatoPod;
import biz.elabor.prebilling.model.statopod.SofStatoPod;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.StatoPodHelper;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.switched.AbstractFunctionalStatoPodHandler;
import biz.elabor.prebilling.services.switched.SofD65Adapter;
import java.util.Date;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public class SofStatoPodHandler
extends AbstractFunctionalStatoPodHandler<Sof> {
    private static final String SOF = "SOF";
    private static final String SNF = "SNF";
    private static final String[] FLUSSI = new String[]{"SOF", "SNF"};

    public SofStatoPodHandler(MisureDao misureDao) {
        super(misureDao);
    }

    @Override
    public void addSospeso(StatusTransaction transaction, Sof item, ErroriElaborazione errore, String message) {
        SofResult result = new SofResult(item, errore, message);
        transaction.addSofSospeso(result);
    }

    @Override
    public void addObsoleto(StatusTransaction transaction, Sof item, ErroriElaborazione errore, String message) {
        SofResult result = new SofResult(item, errore, message);
        transaction.addSofObsoleto(result);
    }

    @Override
    public AbstractBasicStatoPod buildStatoPod(Prestazione prestazione, String flusso, String cpGestore, String cpUtente, Sof sof, StatoPod riferimento, Date dataMovimento, String idMovimento, int nuprogre) {
        AbstractNoncommercialeStatoPod statoPod;
        if (sof.getTrattamento().equals((Object)Trattamento.C)) {
            SofD65Adapter snf = new SofD65Adapter(sof);
            String pivaUtente = snf.getPivaUtente();
            String pivaDispatcher = snf.getPivaUtente();
            String codContrDisp = snf.getCodContrDisp();
            int tensione = Integer.parseInt(snf.getTensione());
            double potenzaContr = snf.getPotImp().doubleValue();
            double potenzaDisp = snf.getPotDisp().doubleValue();
            String cdtardis = snf.getCodiceTariffa();
            String servizioTutela = snf.getServizioTutela();
            String flagResidente = StatoPodHelper.getFlagResidente(snf);
            statoPod = new SnfStatoPod(prestazione, snf, riferimento, nuprogre, pivaUtente, pivaDispatcher, codContrDisp, tensione, potenzaContr, potenzaDisp, cdtardis, servizioTutela, flagResidente);
        } else {
            statoPod = new SofStatoPod(prestazione, flusso, sof, riferimento, nuprogre);
        }
        return statoPod;
    }

    @Override
    public String getCodiceFlusso(Sof sof) {
        return sof != null && sof.getTrattamento().equals((Object)Trattamento.C) ? SNF : SOF;
    }

    @Override
    public void check(SafeListMap<String, Prestazione> prestazioni) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        this.check(prestazioni, FLUSSI);
    }
}

