/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ListMapKeyDate;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.calendar.CalendarioCommercialeHelper;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.SofResult;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.switched.AbstractSelectSwitchStrategy;
import biz.elabor.prebilling.services.switched.SofStatoPodHandler;
import biz.elabor.prebilling.services.switched.SofSwitchHandler;
import java.util.List;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class SelectSofStrategy
extends AbstractSelectSwitchStrategy<Sof> {
    private final PrebillingConfiguration configuration;

    public SelectSofStrategy(PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager) {
        super("SOF", configuration, talkManager, new SofStatoPodHandler(misureDao), new SofSwitchHandler());
        this.configuration = configuration;
    }

    @Override
    public ListMapKeyDate<Sof> getSfs(ServiceStatus status) {
        return status.getSofs();
    }

    @Override
    public void addSospesi(ServiceStatus status, List<Sof> items, ErroriElaborazione error, String description) {
        for (Sof sof : items) {
            SofResult result = new SofResult(sof, error, description);
            status.addSofSospeso(result);
        }
    }

    @Override
    public void handleCommerciale(Sof sof, PraticaVolo pratica, StatusTransaction transaction) {
        SpecificaTecnica dateSpec = pratica.getSpecificaTecnica();
        String codiceOfferta = dateSpec.getCodiceOfferta();
        boolean commerciale = CalendarioCommercialeHelper.isCommerciale(transaction, codiceOfferta, this.configuration);
        sof.setCommerciale(commerciale);
        sof.setCodiceOfferta(codiceOfferta);
    }
}

