/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ListMapKeyDate;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.prebilling.DispatchingFlussi;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.services.switched.MockMisureDao;
import biz.elabor.prebilling.services.switched.SelectSnfStrategy;
import biz.elabor.prebilling.services.switched.SnfD65;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.safe.SimpleSafeListMap;

public class SelectSnfCrmStrategyTest
extends TestCase {
    private MisureDao misureDao;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.misureDao = new MockMisureDao();
    }

    public void testExecuteCrm() {
        TestConfiguration configuration = new TestConfiguration();
        boolean crm = true;
        configuration.setCrm(crm);
        TalkManager talkManager = new TalkManager();
        SelectSnfStrategy strategy = new SelectSnfStrategy(configuration, this.misureDao, talkManager);
        ServiceStatus status = SelectSnfCrmStrategyTest.defineStatusCrm(configuration);
        strategy.execute(status);
        ListMapKeyDate<SnfD65> snfsCrm = status.getSnfsCrm();
        SelectSnfCrmStrategyTest.assertEquals(1, snfsCrm.size());
        Iterator iterator = snfsCrm.iterator();
        List next = (List)iterator.next();
        SelectSnfCrmStrategyTest.assertEquals(1, next.size());
        SnfD65 snfCrm = (SnfD65)next.get(0);
        SelectSnfCrmStrategyTest.assertEquals("pod1", snfCrm.getCodicePod());
        Map<String, List<SnfD65>> snfsNoCrm = status.getSnfsNoCrm();
        boolean empty = snfsNoCrm.isEmpty();
        SelectSnfCrmStrategyTest.assertEquals(true, empty);
    }

    public void testExecuteNoCrm() {
        TestConfiguration configuration = new TestConfiguration();
        boolean crm = false;
        configuration.setCrm(crm);
        TalkManager talkManager = new TalkManager();
        SelectSnfStrategy strategy = new SelectSnfStrategy(configuration, this.misureDao, talkManager);
        ServiceStatus status = SelectSnfCrmStrategyTest.defineStatusNoCrm(configuration);
        strategy.execute(status);
        Map<String, List<SnfD65>> snfsNoCrm = status.getSnfsNoCrm();
        Set<Map.Entry<String, List<SnfD65>>> entrySet = snfsNoCrm.entrySet();
        SelectSnfCrmStrategyTest.assertEquals(1, entrySet.size());
        Iterator<Map.Entry<String, List<SnfD65>>> iterator = entrySet.iterator();
        Map.Entry<String, List<SnfD65>> next = iterator.next();
        List<SnfD65> values = next.getValue();
        SelectSnfCrmStrategyTest.assertEquals(1, values.size());
        SelectSnfCrmStrategyTest.assertEquals("pod1", values.get(0).getCodicePod());
        ListMapKeyDate<SnfD65> snfsCrm = status.getSnfsCrm();
        boolean empty = snfsCrm.isEmpty();
        SelectSnfCrmStrategyTest.assertEquals(true, empty);
    }

    public void testExecuteCrmConPratiche() {
        TestConfiguration configuration = new TestConfiguration();
        boolean crm = true;
        configuration.setCrm(crm);
        TalkManager talkManager = new TalkManager();
        SelectSnfStrategy strategy = new SelectSnfStrategy(configuration, this.misureDao, talkManager);
        ServiceStatus status = SelectSnfCrmStrategyTest.defineStatusCrmConPraticheVolo(configuration);
        strategy.execute(status);
        Map<String, List<SnfD65>> snfsNoCrm = status.getSnfsNoCrm();
        Set<Map.Entry<String, List<SnfD65>>> entrySet = snfsNoCrm.entrySet();
        SelectSnfCrmStrategyTest.assertEquals(1, entrySet.size());
        Iterator<Map.Entry<String, List<SnfD65>>> iterator = entrySet.iterator();
        Map.Entry<String, List<SnfD65>> next = iterator.next();
        List<SnfD65> values = next.getValue();
        SelectSnfCrmStrategyTest.assertEquals(1, values.size());
        SelectSnfCrmStrategyTest.assertEquals("pod1", values.get(0).getCodicePod());
        ListMapKeyDate<SnfD65> snfsCrm = status.getSnfsCrm();
        boolean empty = snfsCrm.isEmpty();
        SelectSnfCrmStrategyTest.assertEquals(true, empty);
    }

    private static ServiceStatus defineStatusNoCrm(PrebillingConfiguration configuration) {
        TestServiceStatus status = new TestServiceStatus(configuration);
        Pod pod = new Pod("pod1", false, 0, "azienda1", null, null, true, true, true, null, "", "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        DefaultPodMap pods = new DefaultPodMap();
        pods.add(pod);
        status.setPodMap(pods);
        Snf snf = new Snf(null, "pod1", "", "", "", null, null, "azienda1", "nomeFile_R.xml", null);
        ArrayList<Snf> snfs = new ArrayList<Snf>();
        snfs.add(snf);
        status.setSnfs(snfs);
        SimpleSafeListMap<String, Prestazione> prestazioni = new SimpleSafeListMap<String, Prestazione>("");
        prestazioni.add(new Prestazione("E", "SE1", "SNF", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "SE1", "F2G", 0, 2, null, null, "", false));
        status.setPrestazioni(prestazioni);
        DefaultListMapKey<String, PraticaVolo> piv = new DefaultListMapKey<String, PraticaVolo>();
        piv.add(new PraticaVolo("pod1", "azienda1", null, null, null, null, 0));
        status.setPiv(piv);
        ArrayList<Reseller> resellers = new ArrayList<Reseller>();
        resellers.add(new Reseller("azienda1", null, null, false, false));
        status.setResellers(resellers);
        return status;
    }

    private static ServiceStatus defineStatusCrmConPraticheVolo(PrebillingConfiguration configuration) {
        TestServiceStatus status = new TestServiceStatus(configuration);
        Reseller reseller = new Reseller("reseller1", "reseller1", "pivaAzienda", false, false);
        ArrayList<Reseller> resellers = new ArrayList<Reseller>();
        resellers.add(reseller);
        status.setResellers(resellers);
        DefaultListMapKey<String, PraticaVolo> piv = new DefaultListMapKey<String, PraticaVolo>();
        PraticaVolo pratica = new PraticaVolo("pod1", "reseller1", null, null, null, null, 0);
        piv.add(pratica);
        status.setPiv(piv);
        Pod pod = new Pod("pod1", false, 0, "azienda1", null, null, true, true, true, null, "", "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        DefaultPodMap pods = new DefaultPodMap();
        pods.add(pod);
        status.setPodMap(pods);
        Snf snf = new Snf(null, "pod1", "", "", "", null, null, null, "", null);
        ArrayList<Snf> snfs = new ArrayList<Snf>();
        snfs.add(snf);
        status.setSnfs(snfs);
        SimpleSafeListMap<String, Prestazione> prestazioni = new SimpleSafeListMap<String, Prestazione>("");
        prestazioni.add(new Prestazione("E", "SE1", "SNF", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "SE1", "F2G", 0, 2, null, null, "", false));
        status.setPrestazioni(prestazioni);
        DispatchingFlussi dispatchingFlussi = new DispatchingFlussi();
        status.setDispatchingFlussi(dispatchingFlussi);
        return status;
    }

    private static ServiceStatus defineStatusCrm(PrebillingConfiguration configuration) {
        TestServiceStatus status = new TestServiceStatus(configuration);
        ArrayList<Reseller> resellers = new ArrayList<Reseller>();
        resellers.add(new Reseller("azienda1", null, null, true, false));
        status.setResellers(resellers);
        DefaultListMapKey<String, PraticaVolo> piv = new DefaultListMapKey<String, PraticaVolo>();
        Date dataInizio = new Date(100000000L);
        SpecificaTecnica specifica = new SpecificaTecnica(null, dataInizio);
        piv.add(new PraticaVolo("pod1", "azienda1", specifica, null, null, null, 0));
        status.setPiv(piv);
        Pod pod = new Pod("pod1", false, 0, "azienda1", null, null, true, true, true, null, "", "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        DefaultPodMap pods = new DefaultPodMap();
        pods.add(pod);
        status.setPodMap(pods);
        Snf snf = new Snf(null, "pod1", "", "", "", dataInizio, null, null, "nomeFile_R.xml", null);
        ArrayList<Snf> snfs = new ArrayList<Snf>();
        snfs.add(snf);
        status.setSnfs(snfs);
        SimpleSafeListMap<String, Prestazione> prestazioni = new SimpleSafeListMap<String, Prestazione>("");
        prestazioni.add(new Prestazione("E", "SE1", "SNF", 0, 2, null, null, "", false));
        prestazioni.add(new Prestazione("E", "SE1", "F2G", 0, 2, null, null, "", false));
        status.setPrestazioni(prestazioni);
        DispatchingFlussi dispatchingFlussi = new DispatchingFlussi();
        status.setDispatchingFlussi(dispatchingFlussi);
        return status;
    }
}

