/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Sof;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.SofResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.common.AbstractExportNoCrmService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;

public class ExportSofNoCrmStrategy
extends AbstractExportNoCrmService
implements ServiceStrategy {
    private final TalkManager talkManager;
    private final Funzionalita funzionalita;

    public ExportSofNoCrmStrategy(Funzionalita funzionalita, PrebillingConfiguration configuration, TalkManager talkManager) {
        super(configuration);
        this.funzionalita = funzionalita;
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        String idEsecuzione = status.getIdEsecuzione();
        Map<String, List<Sof>> sofNoCrm = status.getSofsNoCrm();
        boolean ok = true;
        for (Map.Entry<String, List<Sof>> entry : sofNoCrm.entrySet()) {
            String azienda = entry.getKey();
            PrebillingContext.setContext(this.getClass().getSimpleName(), "azienda: " + azienda);
            List<Sof> sofs = entry.getValue();
            File folder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, this.funzionalita);
            String timestamp = this.timestampFormat.format(new Date());
            String fileName = "switch-d65-dati-funzionali-orari-" + azienda + "-" + timestamp + ".csv";
            File file = new File(folder, fileName);
            String servizio = "SE1";
            try {
                PrintWriter writer = new PrintWriter(file);
                writer.println("D65;POD;DATAEVASIO;MATRICOLA1");
                for (Sof sof : sofs) {
                    this.printSof(sof, servizio, false, writer);
                    status.addSofElaborato(new SofResult(sof, ErroriElaborazione.OK, ""));
                    String flusso = sof.getCodiceFlusso();
                    status.count(azienda, flusso, 1);
                }
                writer.close();
            }
            catch (FileNotFoundException exc) {
                Warning sentence = new Warning("export.switch.no.crm", "file.createFailed");
                sentence.setCss("alert-danger");
                sentence.addParam(file.getAbsolutePath());
                this.talkManager.addSentence(sentence);
                ok = false;
            }
        }
        return ok;
    }

    private void printSof(Sof sof, String servizio, boolean commerciale, PrintWriter writer) {
        Date date = sof.getDate();
        String codice = sof.getCodicePod();
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codice);
        writer.print(";");
        writer.print(codice.trim());
        writer.print(";");
        writer.print(this.dataFormat.format(date));
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";;;;");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";;;;");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";;;;");
        writer.print(";");
        if (commerciale) {
            writer.print(";");
            writer.print(";");
            writer.print(";");
            String EaF1 = ExportSofNoCrmStrategy.getDato(0.0, DECIMAL_FORMAT_MISURE, 0.0);
            writer.print(EaF1);
            writer.print(";");
            String EaF2 = ExportSofNoCrmStrategy.getDato(0.0, DECIMAL_FORMAT_MISURE, 0.0);
            writer.print(EaF2);
            writer.print(";");
            String EaF3 = ExportSofNoCrmStrategy.getDato(0.0, DECIMAL_FORMAT_MISURE, 0.0);
            writer.print(EaF3);
            writer.print(";");
        } else {
            writer.print(";;;;;;");
        }
        writer.print(sof.getTrattamento().getFasce());
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(servizio);
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print(";");
        writer.print((Object)sof.getTrattamento());
        writer.print(";");
        writer.print(sof.getTensione().trim());
        writer.print(";");
        writer.print(DECIMAL_FORMAT_OUT.format(sof.getPotImp()));
        writer.print(";");
        writer.print(DECIMAL_FORMAT_OUT.format(sof.getPotDisp()));
        writer.print(";");
        writer.println("*");
    }
}

