/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.switched;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.SnfResult;
import biz.elabor.prebilling.model.statopod.AbstractBasicStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.model.statopod.SnfStatoPod;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.switched.AbstractFunctionalStatoPodHandler;
import biz.elabor.prebilling.services.switched.DefaultStatoPodIH;
import biz.elabor.prebilling.services.switched.StatoPodInitHandler;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public abstract class AbstractSnfStatoPodHandler
extends AbstractFunctionalStatoPodHandler<Snf> {
    private static final String[] FLUSSI = new String[]{"SNF", "F2G"};
    private final StatoPodInitHandler handler;

    public AbstractSnfStatoPodHandler(MisureDao misureDao) {
        super(misureDao);
        this.handler = new DefaultStatoPodIH();
    }

    public AbstractSnfStatoPodHandler(MisureDao misureDao, StatoPodInitHandler handler) {
        super(misureDao, handler.getCodicePrestazione());
        this.handler = handler;
    }

    @Override
    public void addSospeso(StatusTransaction transaction, Snf item, ErroriElaborazione errore, String messaggio) {
        SnfResult snfResult = new SnfResult(item, errore, messaggio);
        transaction.addSnfSospeso(snfResult);
    }

    @Override
    public void addObsoleto(StatusTransaction transaction, Snf item, ErroriElaborazione errore, String messaggio) {
        SnfResult snfResult = new SnfResult(item, errore, messaggio);
        transaction.addSnfObsoleto(snfResult);
    }

    protected AbstractBasicStatoPod buildStatoPod(Prestazione prestazione, Snf snf, StatoPod riferimento, int tensione, double potenzaContr, double potenzaDisp, String cdtardis, String servizioTutela, int nuprogre, String flagResidente) {
        String pivaDistributore = this.handler.getPivaDistributore(snf, riferimento);
        String pivaDispatcher = this.handler.getPivaDispatcher(snf, riferimento);
        String codContrDisp = this.handler.getCodContrDisp(snf, riferimento);
        return new SnfStatoPod(prestazione, snf, riferimento, nuprogre, pivaDistributore, pivaDispatcher, codContrDisp, tensione, potenzaContr, potenzaDisp, cdtardis, servizioTutela, flagResidente);
    }

    @Override
    public void check(SafeListMap<String, Prestazione> prestazioni) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        this.check(prestazioni, FLUSSI);
    }
}

