/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.ricalcolotariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.IndiciDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.Multipunto;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.MappaContratti;
import biz.elabor.prebilling.model.indici.MappaIndici;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.tariffe.Destinatari;
import biz.elabor.prebilling.services.tariffe.TariffaMultiApplicazione;
import biz.elabor.prebilling.services.tariffe.TariffeBuilder;
import biz.elabor.prebilling.services.tariffe.TipoCalcolo;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.listmap.ListMap;

public abstract class AbstractRicalcoloTariffeStrategy
implements ServiceStrategy {
    private final Destinatari destinatari;
    protected final int anno;
    protected final Month mese;
    protected final int annoStart;
    protected final Month meseStart;
    protected final int annoEnd;
    protected final Month meseEnd;
    protected final TipoCalcolo tipo;
    protected final TipoTrattamento tipoTrattamento;
    protected final boolean scivoloEnabled;
    protected final boolean scivoloForced;
    protected final Set<String> podSet;
    protected final String reseller;
    protected final PrebillingConfiguration configuration;
    protected final GiadaDao giadaDao;
    protected final MisureDao misureDao;
    protected final IndiciDao indiciDao;
    protected final TalkManager talkManager;
    protected final boolean bloccoIndice;

    protected abstract MappaContratti getContratti();

    protected abstract ServiceStrategy getExportStrategy(Date var1);

    protected abstract void setTariffe(ListMap<String, TariffaMultiApplicazione> var1, ServiceStatus var2);

    public AbstractRicalcoloTariffeStrategy(Destinatari destinatari, int anno, Month mese, int annoStart, Month meseStart, int annoEnd, Month meseEnd, TipoCalcolo tipo, TipoTrattamento tipoTrattamento, boolean scivoloEnabled, boolean scivoloForced, List<String> podList, String reseller, boolean bloccoIndice, PrebillingConfiguration configuration, GiadaDao giadaDao, MisureDao misureDao, IndiciDao indiciDao, TalkManager talkManager) {
        this.destinatari = destinatari;
        this.anno = anno;
        this.mese = mese;
        this.annoStart = annoStart;
        this.meseStart = meseStart;
        this.annoEnd = annoEnd;
        this.meseEnd = meseEnd;
        this.tipo = tipo;
        this.tipoTrattamento = tipoTrattamento;
        this.scivoloEnabled = scivoloEnabled;
        this.scivoloForced = scivoloForced;
        this.reseller = reseller;
        this.podSet = new LinkedHashSet<String>(podList);
        this.configuration = configuration;
        this.giadaDao = giadaDao;
        this.misureDao = misureDao;
        this.indiciDao = indiciDao;
        this.talkManager = talkManager;
        this.bloccoIndice = bloccoIndice;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        status.setMappaIndici(new MappaIndici(this.anno, this.mese, this.indiciDao, this.configuration, status));
        ListMap<String, TariffaMultiApplicazione> tariffe = new BasicListMap<String, TariffaMultiApplicazione>();
        this.setTariffe(tariffe, status);
        Map<String, Multipunto> multiPodMap = this.misureDao.getMultiPodMap(this.anno, this.mese);
        MappaContratti contratti = this.getContratti();
        try {
            TariffeBuilder builder = new TariffeBuilder(this.anno, this.mese, this.tipo, this.destinatari, this.podSet, contratti, multiPodMap, this.misureDao, this.configuration, this.talkManager, status, this.annoStart, this.meseStart, this.annoEnd, this.meseEnd, this.scivoloEnabled, this.scivoloForced, "", this.tipoTrattamento, true, this.bloccoIndice);
            tariffe = builder.buildTariffe();
            this.setTariffe(tariffe, status);
            boolean endMonth = this.anno == this.annoEnd && this.mese.equals((Object)this.meseEnd);
            Date dataMax = endMonth ? null : CalendarTools.getEndDate(this.anno, this.mese);
            ServiceStrategy exportStrategy = this.getExportStrategy(dataMax);
            ok = exportStrategy.execute(status);
        }
        catch (CalendarNotFoundException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("compute.tariffe", message);
            sentence.addParam(exc.getKey());
            sentence.addParam(exc.getCodicePod());
            sentence.setCss("alert-danger");
            this.talkManager.addSentence(sentence);
            ok = true;
        }
        catch (InconsistentOptionException exc) {
            ok = true;
        }
        return ok;
    }
}

