/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.riallineamento;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.RigaPod;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.Month;

public class GetAllPodStrategy
implements ServiceStrategy {
    private int anno;
    private Month mese;
    private PrebillingConfiguration configuration;
    private GiadaDao dao;

    public GetAllPodStrategy(int anno, Month mese, PrebillingConfiguration configuration, GiadaDao dao) {
        this.anno = anno;
        this.mese = mese;
        this.configuration = configuration;
        this.dao = dao;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        DefaultPodMap pods = this.getPods();
        status.setAllPods(pods);
        return true;
    }

    private DefaultPodMap getPods() {
        DefaultPodMap podMap = new DefaultPodMap();
        String cclettur = this.configuration.getCclettur();
        List<RigaPod> righePod = this.dao.getRighePod(this.anno, this.mese, cclettur);
        Date dataInizio = new Date(0L);
        righePod.add(new RigaPod("zzzz", null, false, 0, dataInizio, null, null, null, false, false, false, null, false, null, null, "dispatcher", null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "0", 1.0, 1.0, 1.0, false, false, dataInizio, null, null));
        StrategyHelper.fillPodMap(righePod, this.anno, this.mese, podMap);
        return podMap;
    }
}

