/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.riallineamento;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.letture.PrebillingTestHelper;
import biz.elabor.prebilling.services.riallineamento.CheckPnoRiallineamentoStrategy;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.homelinux.elabor.springtools.web.widgets.Sentence;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.safe.SimpleSafeMap;

public class CheckPnoRiallineamentoStrategyTest
extends TestCase {
    public void testExecute() {
        TestConfiguration configuration = new TestConfiguration();
        ServiceStatus status = CheckPnoRiallineamentoStrategyTest.defineStatus(configuration);
        TalkManager talkManager = new TalkManager();
        CheckPnoRiallineamentoStrategy strategy = new CheckPnoRiallineamentoStrategy(talkManager);
        strategy.execute(status);
        List<Sentence> sentences = talkManager.getSentences();
        CheckPnoRiallineamentoStrategyTest.assertEquals(2, sentences.size());
        Sentence sentence = sentences.get(0);
        CheckPnoRiallineamentoStrategyTest.assertEquals("check.pnoRiallineamento.strategy", sentence.getTitle());
        CheckPnoRiallineamentoStrategyTest.assertEquals("pno.noPod", sentence.getDescription());
        CheckPnoRiallineamentoStrategyTest.assertEquals("pod1", sentence.getParams().get(0));
        sentence = sentences.get(1);
        CheckPnoRiallineamentoStrategyTest.assertEquals("check.pnoRiallineamento.strategy", sentence.getTitle());
        CheckPnoRiallineamentoStrategyTest.assertEquals("pno.podOrario", sentence.getDescription());
        CheckPnoRiallineamentoStrategyTest.assertEquals("pod2", sentence.getParams().get(0));
    }

    private static ServiceStatus defineStatus(PrebillingConfiguration configuration) {
        TestServiceStatus status = new TestServiceStatus(configuration);
        SimpleSafeMap<String, Mno> pnos = new SimpleSafeMap<String, Mno>("pno");
        HashMap<String, Map<String, String>> datipod = new HashMap<String, Map<String, String>>();
        datipod.put("DatiPdp", new HashMap());
        Misura misura = PrebillingTestHelper.newMisura(new Date(0L), false, 0);
        Mno pno1 = new Mno(null, null, "pod1", misura, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
        Mno pno2 = new Mno(null, null, "pod2", misura, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
        Mno pno3 = new Mno(null, null, "pod3", misura, null, null, "dispatcher", null, null, null, null, datipod, "", "", null, null, null, "", "", null, "");
        pnos.add(pno1);
        pnos.add(pno2);
        pnos.add(pno3);
        status.setRiallineamentoPnos(pnos);
        DefaultPodMap pods = new DefaultPodMap();
        Pod pod2 = new Pod("pod2", true, 0, "", null, null, false, false, false, null, "", "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        Pod pod3 = new Pod("pod3", false, 0, "", null, null, false, false, false, null, "", "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        pods.add(pod2);
        pods.add(pod3);
        status.setAllPods(pods);
        return status;
    }
}

