/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.riallineamento;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import java.util.Date;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.safe.SafeMap;

public class CheckPnoRiallineamentoStrategy
implements ServiceStrategy {
    private TalkManager talkManager;

    public CheckPnoRiallineamentoStrategy(TalkManager talkManager) {
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        SafeMap<String, Mno> pnos = status.getRiallineamentoPnos();
        DefaultPodMap pods = status.getAllPods();
        for (Mno pno : pnos) {
            String codicePod = pno.getCodicePod();
            PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
            try {
                Pod pod = pods.get(codicePod);
                Date dataMisura = pno.getDataMisura();
                if (pod.isAzzeramento(dataMisura)) {
                    Warning sentence = new Warning("check.pnoRiallineamento.strategy", "pno.podOrario");
                    sentence.addParam(codicePod);
                    sentence.setCss("alert-warning");
                    this.talkManager.addSentence(sentence);
                }
                StrategyHelper.handleKX(pod, pno);
            }
            catch (DataNotFoundException e2) {
                Warning sentence = new Warning("check.pnoRiallineamento.strategy", "pno.noPod");
                sentence.addParam(codicePod);
                sentence.setCss("alert-warning");
                this.talkManager.addSentence(sentence);
            }
        }
        return true;
    }
}

