/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.rettifiche;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.statopod.AbstractBasicStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.RsnRvnStatoPod;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.AbstractPrestazioneStatoPodHandler;
import biz.elabor.prebilling.services.letture.MisuraMno;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public class RsnRnvStatoPodHandler
extends AbstractPrestazioneStatoPodHandler<MisuraMno> {
    private static final String RNV = "RNV";
    private static final String RSN = "RSN";
    private static final Map<String, List<String>> MAPPA_PRESTAZIONI = new HashMap<String, List<String>>();

    static {
        MAPPA_PRESTAZIONI.put("SE1", Arrays.asList(RSN));
        MAPPA_PRESTAZIONI.put("VT1", Arrays.asList(RNV));
        MAPPA_PRESTAZIONI.put("VT3", Arrays.asList(RNV));
    }

    public RsnRnvStatoPodHandler(MisureDao misureDao) {
        super("E", misureDao);
    }

    @Override
    public AbstractBasicStatoPod buildStatoPod(Prestazione prestazione, String flusso, String cpGestore, String cpUtente, MisuraMno misura, StatoPod riferimento, Date dataMovimento, String idMoovimento, int nuprogre) {
        return new RsnRvnStatoPod(prestazione, flusso, misura, riferimento, nuprogre);
    }

    public void check(SafeListMap<String, Prestazione> prestazioni) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        this.check(prestazioni, MAPPA_PRESTAZIONI);
    }
}

