/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.rettifiche;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.misure.ExtendedLT;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.LetstdPrintMapWriter;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.rettifiche.RettificaType;
import biz.elabor.prebilling.services.rettifiche.RsnRnvStatoPodHandler;
import biz.elabor.prebilling.util.MapWriter;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class ExportRsnRnvStrategy
implements ServiceStrategy {
    private static final String SERVIZIO = "E";
    private final int anno;
    private final Month mese;
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final RsnRnvStatoPodHandler statoPodHandler;
    private final PrebillingConfiguration configuration;
    private final Date timestamp;

    public ExportRsnRnvStrategy(int anno, Month mese, PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager, Date timestamp) {
        this.configuration = configuration;
        this.anno = anno;
        this.mese = mese;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.timestamp = timestamp;
        this.statoPodHandler = new RsnRnvStatoPodHandler(misureDao);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        try {
            SafeListMap<String, Prestazione> prestazioni = status.getPrestazioni();
            this.statoPodHandler.check(prestazioni);
            this.writeMisure(status);
            this.print(status);
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning("export.rsnrnv.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getMessage());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (SegnaleNotHandledException exc) {
            Warning sentence = new Warning("export.stdlet.strategy", "segnale.nothandled");
            sentence.setCss("alert-danger");
            Prestazione prestazione = exc.getPrestazione();
            sentence.addParam(prestazione.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (PrestazioneNotFoundException exc) {
            Warning sentence = new Warning("export.stdlet.strategy", "prestazione.notfound");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void print(ServiceStatus status) throws FileNotFoundException {
        String idEsecuzione = status.getIdEsecuzione();
        Map<String, Map<String, MapWriter>> writer = status.getRettificheDispatcherWriter();
        this.printDispatcher(idEsecuzione, writer, "");
        Map<String, Map<String, MapWriter>> writerIV = status.getRettificheIVDispatcherWriter();
        this.printDispatcher(idEsecuzione, writerIV, "iv-");
        writer = status.getRettificheResellerWriter();
        this.printReseller(idEsecuzione, writer, "");
        writerIV = status.getRettificheIVResellerWriter();
        this.printReseller(idEsecuzione, writerIV, "iv-");
    }

    private void printDispatcher(String idEsecuzione, Map<String, Map<String, MapWriter>> rettificheWriter, String specSpec) throws FileNotFoundException {
        for (Map.Entry<String, Map<String, MapWriter>> entry : rettificheWriter.entrySet()) {
            String codiceFlusso = entry.getKey();
            Map<String, MapWriter> mapWriters = entry.getValue();
            LetstdPrintMapWriter writer = new LetstdPrintMapWriter(this.anno, this.mese, this.configuration);
            String preSpec = String.valueOf(codiceFlusso.toLowerCase()) + "-" + specSpec;
            writer.printDispatcher(idEsecuzione, mapWriters, preSpec, "", this.timestamp);
        }
    }

    private void printReseller(String idEsecuzione, Map<String, Map<String, MapWriter>> rettificheWriter, String specSpec) throws FileNotFoundException {
        for (Map.Entry<String, Map<String, MapWriter>> entry : rettificheWriter.entrySet()) {
            String codiceFlusso = entry.getKey();
            Map<String, MapWriter> mapWriters = entry.getValue();
            LetstdPrintMapWriter writer = new LetstdPrintMapWriter(this.anno, this.mese, this.configuration);
            String preSpec = String.valueOf(codiceFlusso.toLowerCase()) + "-" + specSpec;
            writer.printRettificheReseller(idEsecuzione, mapWriters, preSpec, "", this.timestamp);
        }
    }

    private void writeMisure(ServiceStatus status) {
        SafeMap<String, Reseller> resellers = status.getResellers();
        ListMap<String, Mno> rsnRnv = status.getRsnRnv();
        PodMap pods = status.getPodMap();
        for (Map.Entry entry : rsnRnv.entrySet()) {
            String codicePod = (String)entry.getKey();
            List mnoPod = (List)entry.getValue();
            try {
                Pod pod = pods.get(codicePod);
                StatusTransaction transaction = new StatusTransaction(null, status, this.configuration);
                this.writeMisure(transaction, resellers, pod, mnoPod);
                transaction.commit(pod);
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message("export.stdlet.strategy", message);
                sentence.setCss("alert-danger");
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                Date endOfTime = CalendarTools.getEndOfTime();
                status.addMnoSospesi(mnoPod, errore, descrizione, endOfTime);
            }
            catch (RuntimeException exc) {
                String descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, "export.stdlet.strategy", this.talkManager, status);
                status.addPnoEsclusi(mnoPod, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
            }
        }
    }

    private Mno check(Mno mno) throws DataNotFoundException {
        Mno orig = null;
        String codiceFlusso = mno.getCodiceFlusso();
        orig = codiceFlusso.startsWith("RNV") ? this.misureDao.getVno(mno) : (codiceFlusso.startsWith("RSN") ? this.misureDao.getSnm(mno) : mno);
        return orig;
    }

    private void writeMisure(StatusTransaction transaction, SafeMap<String, Reseller> resellers, Pod pod, List<Mno> mnoPod) throws DataNotFoundException {
        String azienda = pod.getAzienda();
        transaction.setAzienda(azienda);
        Reseller reseller = (Reseller)resellers.get(azienda);
        Date dataPrec = null;
        for (Mno mno : mnoPod) {
            MnoResult result;
            String message;
            mno.setCdaziend(azienda);
            Mno orig = this.check(mno);
            Date dataMisura = orig.getDataMisura();
            if (dataPrec == null || !dataPrec.equals(dataMisura)) {
                try {
                    this.writeMisure(mno, orig, pod, reseller, transaction);
                }
                catch (StatoPodCheckException exc) {
                    throw new RuntimeException(exc);
                }
                catch (PraticaAnnullataException exc) {
                    message = exc.getMessage();
                    String key = exc.getKey();
                    Message sentence = new Message("export.stdlet.strategy", message);
                    sentence.addParam(key);
                    String descrizione = this.talkManager.getMessage(sentence);
                    ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                    result = new MnoResult(mno, errore, descrizione);
                    transaction.addPnoObsoleto(result);
                }
            } else {
                ErroriElaborazione errore = ErroriElaborazione.OBSOLETO;
                message = errore.getMessage();
                Message sentence = new Message("export.stdlet.strategy", message);
                String codicePod = pod.getCodice();
                sentence.addParam(String.valueOf(codicePod) + "/" + azienda);
                DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
                sentence.addParam(dateFormat.format(mno.getDataMisura()));
                String descrizione = this.talkManager.getMessage(sentence);
                result = new MnoResult(mno, errore, descrizione);
                transaction.addPnoObsoleto(result);
            }
            dataPrec = dataMisura;
        }
    }

    private void writeMisure(Mno mno, Mno orig, Pod pod, Reseller reseller, StatusTransaction transaction) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        Date dataMisura = orig.getDataMisura();
        boolean allineati = ExportRsnRnvStrategy.checkAllineati(mno, pod, dataMisura);
        String codicePod = pod.getCodice();
        if (allineati || pod.isNuovaFornitura()) {
            if (pod.isAttesaSnm()) {
                Message sentence = new Message("export.stdlet.strategy", "attesa.snm");
                sentence.setCss("alert-danger");
                sentence.addParam(codicePod);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                MnoResult result = new MnoResult(mno, ErroriElaborazione.INATTESA_SNM, descrizione);
                transaction.addPnoSospeso(result);
            } else {
                String codicePrestazione;
                String codiceFlusso = mno.getCodiceFlusso();
                Date dataInizio = pod.getDataInizio(dataMisura);
                if (pod.isPodNuovo(dataMisura) && dataInizio != null && dataInizio.equals(dataMisura)) {
                    dataMisura = CalendarTools.previousDay(dataMisura);
                }
                mno.setDataMisura(dataMisura);
                MisuraMno misuraMno = new MisuraMno(pod, mno);
                if (reseller.isHandleStato()) {
                    RettificaType type = RettificaType.valueOf(codiceFlusso);
                    String cpGestore = mno.getCodPratAtt();
                    StatoPod statoPod = type.getStatoPod(this.misureDao, SERVIZIO, codicePod, cpGestore, dataMisura);
                    codicePrestazione = statoPod.getCdunipre();
                    cpGestore = statoPod.getCpGestore();
                    this.statoPodHandler.handleStato(misuraMno, codicePrestazione, cpGestore, transaction);
                } else {
                    codicePrestazione = "";
                }
                if (allineati) {
                    transaction.addMisuraRettifica(misuraMno);
                } else {
                    ExtendedLT misura = new ExtendedLT(mno, orig, pod, pod, false, codicePrestazione, codiceFlusso, "G");
                    transaction.addMisuraTecnica(misura);
                }
                MnoResult result = new MnoResult(mno, ErroriElaborazione.OK, "");
                transaction.addPnoElaborato(result);
                transaction.count(codiceFlusso);
            }
        } else {
            Message sentence = new Message("export.stdlet.strategy", "notcoherent.k");
            sentence.setCss("alert-warning");
            sentence.addParam(codicePod);
            this.talkManager.addSentence(sentence);
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(mno, ErroriElaborazione.K_NOTCOHERENT, descrizione);
            transaction.addPnoSospeso(result);
        }
    }

    private static boolean checkAllineati(Mno mno, Pod pod, Date data) {
        return ExportRsnRnvStrategy.checkKa(mno, pod, data) && ExportRsnRnvStrategy.checkKr(mno, pod, data) && ExportRsnRnvStrategy.checkKp(mno, pod, data);
    }

    private static boolean checkKa(Mno mno, Pod pod, Date data) {
        return !pod.isMisuraAttiva(data) || pod.getKa(data) == mno.getKa().doubleValue();
    }

    private static boolean checkKr(Mno mno, Pod pod, Date data) {
        return !pod.isMisuraReattiva(data) || pod.getKr(data) == mno.getKr().doubleValue();
    }

    private static boolean checkKp(Mno mno, Pod pod, Date data) {
        return !pod.isMisuraPotenza(data) || pod.getKp(data) == mno.getKp().doubleValue();
    }
}

