/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.rettifiche;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.Rno;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.text.Format;

public class ExportLogRettifiche
implements ServiceStrategy {
    private static final DecimalFormat OUTPUT_DOUBLE_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "+000000000.000");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private int anno;
    private Month mese;
    private PrebillingConfiguration configuration;
    private TalkManager talkManager;

    public ExportLogRettifiche(int anno, Month mese, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.configuration = configuration;
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok = this.exportRnoLog(status);
        return ok &= this.exportRfoLog(status);
    }

    private boolean exportRfoLog(ServiceStatus status) {
        boolean ok = true;
        List<Pdo> rfoList = status.getLogRfo();
        if (!rfoList.isEmpty()) {
            ok = this.exportRfoLog(status, rfoList);
        }
        return ok;
    }

    private boolean exportRfoLog(ServiceStatus status, List<Pdo> rfoList) {
        boolean ok;
        String idEsecuzione = status.getIdEsecuzione();
        File folder = ConfigurationHelper.getDispatcherTmpLettureFolder(this.configuration, idEsecuzione, Funzionalita.LETTURE);
        Date now = new Date();
        String timestamp = TIME_FORMAT.format(now);
        String fileName = "rettifiche-orarie-" + this.anno + "-" + this.mese.getIndex() + "-" + timestamp + ".txt";
        File file = new File(folder, fileName);
        try {
            PrintWriter writer = new PrintWriter(file);
            for (Pdo rfo : rfoList) {
                String codicePod = rfo.getCodicePod();
                PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
                RilMese rilMese = rfo.getRilMese();
                int annoRfo = rilMese.getAnno();
                Month meseRfo = rilMese.getMese();
                writer.println(String.valueOf(codicePod) + ";" + annoRfo + ";" + meseRfo.getIndex() + ";" + rfo.getEAF1() + ";" + rfo.getEAF2() + ";" + rfo.getEAF3() + ";" + rfo.getERF1() + ";" + rfo.getERF2() + ";" + rfo.getERF3() + ";" + rfo.getPotF1String() + ";" + rfo.getPotF2String() + ";" + rfo.getPotF3String());
                String azienda = rfo.getCdaziend();
                status.addRfoElaborato(azienda, new PdoResult(rfo, ErroriElaborazione.OK, ""));
                String flusso = rfo.getFirstCodiceFlusso();
                status.count(azienda, flusso, 1);
            }
            writer.close();
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning("export.rettifiche.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(file.getAbsolutePath());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private boolean exportRnoLog(ServiceStatus status) {
        List<Rno> rnosList = status.getRno();
        List<Mno> rnos = this.findToExport(rnosList, status);
        boolean ok = true;
        if (!rnos.isEmpty()) {
            ok = this.exportLog(status, rnos);
        }
        return ok;
    }

    public boolean exportLog(ServiceStatus status, List<Mno> rnos) {
        boolean ok;
        String idEsecuzione = status.getIdEsecuzione();
        File folder = ConfigurationHelper.getDispatcherTmpLettureFolder(this.configuration, idEsecuzione, Funzionalita.LETTURE);
        Date now = new Date();
        String timestamp = TIME_FORMAT.format(now);
        String fileName = "rettifiche-nonorarie-" + this.anno + "-" + this.mese.getIndex() + "-" + timestamp + ".txt";
        File file = new File(folder, fileName);
        try {
            PrintWriter writer = new PrintWriter(file);
            for (Mno rno : rnos) {
                String codicePod = rno.getCodicePod();
                PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
                Date data = rno.getDataMisura();
                Misura misura = rno.getMisura();
                String dataFormattata = DATE_FORMAT.format(data);
                writer.println(String.valueOf(codicePod) + ";" + dataFormattata + ";" + ExportLogRettifiche.format(misura.getAttiva(FasciaOraria.F1).getNetto()) + ";" + ExportLogRettifiche.format(misura.getAttiva(FasciaOraria.F2).getNetto()) + ";" + ExportLogRettifiche.format(misura.getAttiva(FasciaOraria.F3).getNetto()) + ";" + ExportLogRettifiche.format(misura.getReattiva(FasciaOraria.F1).getNetto()) + ";" + ExportLogRettifiche.format(misura.getReattiva(FasciaOraria.F2).getNetto()) + ";" + ExportLogRettifiche.format(misura.getReattiva(FasciaOraria.F3).getNetto()) + ";" + ExportLogRettifiche.format(misura.getPotenza(FasciaOraria.F1).getNetto()) + ";" + ExportLogRettifiche.format(misura.getPotenza(FasciaOraria.F2).getNetto()) + ";" + ExportLogRettifiche.format(misura.getPotenza(FasciaOraria.F3).getNetto()) + ";");
                status.addRnoElaborato(new MnoResult(rno, ErroriElaborazione.OK, ""));
                String flusso = rno.getCodiceFlusso();
                String azienda = rno.getCdaziend();
                status.count(azienda, flusso, 1);
            }
            writer.close();
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning("export.rettifiche.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(file.getAbsolutePath());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private List<Mno> findToExport(List<Rno> rnosList, ServiceStatus status) {
        ArrayList<Mno> rnos = new ArrayList<Mno>();
        for (Rno rno : rnosList) {
            Mno mno = rno.getMno();
            try {
                String codicePod = mno.getCodicePod();
                String className = this.getClass().getSimpleName();
                PrebillingContext.setContext(className, "pod: " + codicePod);
                StrategyHelper.handleKX(rno);
                String azienda = rno.getAzienda();
                mno.setCdaziend(azienda);
                rnos.add(mno);
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("export.rettifiche.strategy", message);
                sentence.setCss("alert-warning");
                String key = exc.getKey();
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                MnoResult result = new MnoResult(mno, ErroriElaborazione.POD_NOTFOUND, descrizione);
                status.addRnoSospeso(result);
            }
        }
        return rnos;
    }

    private static String format(double value) {
        return OUTPUT_DOUBLE_FORMAT.format(value);
    }
}

