/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.reseller;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.reseller.GetResellerPodStrategy;
import biz.elabor.prebilling.services.reseller.MnoSplitHandler;
import biz.elabor.prebilling.services.reseller.PdoSplitHandler;
import biz.elabor.prebilling.services.reseller.SnfSplitHandler;
import biz.elabor.prebilling.services.reseller.SofSplitHandler;
import biz.elabor.prebilling.services.reseller.SplitHandler;
import biz.elabor.prebilling.web.xml.Partition;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class SplitResellerStrategy
implements ServiceStrategy {
    private final PrebillingConfiguration configuration;
    private final GiadaDao giadaDao;
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final int prefixLength;
    private final int maxPrefixCount;

    public SplitResellerStrategy(PrebillingConfiguration configuration, GiadaDao giadaDao, MisureDao misureDao, TalkManager talkManager) {
        this.configuration = configuration;
        this.giadaDao = giadaDao;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.prefixLength = this.configuration.getPrefixLength();
        this.maxPrefixCount = this.configuration.getMaxPrefixCount();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        SplitHandler[] handlers = new SplitHandler[]{new MnoSplitHandler(this.configuration, this.misureDao, this.talkManager), new PdoSplitHandler(this.configuration, this.misureDao, this.talkManager), new SnfSplitHandler(this.configuration, this.misureDao, this.talkManager), new SofSplitHandler(this.configuration, this.misureDao, this.talkManager)};
        for (ElaborCalendar month : SplitResellerStrategy.getMonths(handlers)) {
            this.handleMonth(month, handlers, status);
        }
        return true;
    }

    private static Set<ElaborCalendar> getMonths(SplitHandler[] handlers) {
        TreeSet<ElaborCalendar> months = new TreeSet<ElaborCalendar>();
        SplitHandler[] splitHandlerArray = handlers;
        int n2 = handlers.length;
        int n3 = 0;
        while (n3 < n2) {
            SplitHandler handler = splitHandlerArray[n3];
            months.addAll(handler.getMonths());
            ++n3;
        }
        return months;
    }

    private void handleMonth(ElaborCalendar month, SplitHandler[] handlers, ServiceStatus status) {
        int anno = month.getAnno();
        Month mese = month.getMese();
        Logger logger = status.getLogger();
        logger.info("elaborazione anno " + anno + " mese " + (Object)((Object)mese));
        GetResellerPodStrategy podStrategy = new GetResellerPodStrategy(anno, mese, this.giadaDao);
        podStrategy.execute(status);
        SplitHandler[] splitHandlerArray = handlers;
        int n2 = handlers.length;
        int n3 = 0;
        while (n3 < n2) {
            SplitHandler handler = splitHandlerArray[n3];
            this.executeHandler(month, handler, status);
            ++n3;
        }
    }

    private void executeHandler(ElaborCalendar month, SplitHandler handler, ServiceStatus status) {
        List<Partition> prefixes = handler.getPrefixes(month, "", this.prefixLength);
        Collections.sort(prefixes);
        this.execute(month, prefixes, handler, status);
    }

    public void execute(ElaborCalendar month, List<Partition> prefixes, SplitHandler handler, ServiceStatus status) {
        for (Partition Partition2 : prefixes) {
            this.execute(month, Partition2, handler, status);
        }
    }

    public void execute(ElaborCalendar month, Partition Partition2, SplitHandler handler, ServiceStatus status) {
        String prefix = Partition2.getPrefix();
        int count = Partition2.getCount();
        if (count > this.maxPrefixCount) {
            List<Partition> prefixes = handler.getPrefixes(month, prefix, prefix.length() + 1);
            Collections.sort(prefixes);
            this.execute(month, prefixes, handler, status);
        } else {
            handler.execute(month, prefix, status);
        }
    }
}

