/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.reseller;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.reseller.FlussoReseller;
import biz.elabor.prebilling.services.reseller.ResellerPod;
import biz.elabor.prebilling.services.reseller.ResellerPodMap;
import java.util.Date;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class SetResellerStrategy
implements ServiceStrategy {
    private final TalkManager talkManager;
    private final String aziendaDefault;
    private final int ritardo;
    private final PrebillingConfiguration configuration;

    public SetResellerStrategy(PrebillingConfiguration configuration, TalkManager talkManager) {
        this.talkManager = talkManager;
        this.configuration = configuration;
        this.aziendaDefault = configuration.getDefaultAzienda();
        this.ritardo = configuration.getRitardoAzienda();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ResellerPodMap podMap = status.getResellerPodMap();
        for (FlussoReseller flusso : status.getFlussiReseller()) {
            String codicePod = flusso.getCodicePod();
            Date data = flusso.getData();
            try {
                ResellerPod pod = podMap.get(codicePod, data);
                String azienda = pod.getAzienda();
                flusso.setCodiceAzienda(azienda);
            }
            catch (DataNotFoundException exc) {
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message("reseller", message);
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                Date timeout = this.configuration.getTimeout(this.ritardo);
                if (!data.before(timeout)) continue;
                flusso.setCodiceAzienda(this.aziendaDefault);
            }
        }
        return true;
    }
}

