/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.reseller;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.reseller.AbstractSplitHandler;
import biz.elabor.prebilling.services.reseller.GetPdoResellerStrategy;
import biz.elabor.prebilling.services.reseller.RecordPdoResellerStrategy;
import biz.elabor.prebilling.services.reseller.SetResellerStrategy;
import biz.elabor.prebilling.web.xml.Partition;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

class PdoSplitHandler
extends AbstractSplitHandler {
    public PdoSplitHandler(PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager) {
        super(configuration, misureDao, talkManager);
    }

    @Override
    public List<ElaborCalendar> getMonths() {
        return this.misureDao.getPdoMonths();
    }

    @Override
    public List<Partition> getPrefixes(ElaborCalendar month, String currPrefix, int prefixLength) {
        return this.misureDao.getPdoPrefixes(month, currPrefix, prefixLength);
    }

    @Override
    protected StrategiesManager buildStrategies(ElaborCalendar month, String prefix) {
        StrategiesManager manager = new StrategiesManager(this.configuration);
        manager.addStrategy(new GetPdoResellerStrategy(month, prefix, this.misureDao));
        manager.addStrategy(new SetResellerStrategy(this.configuration, this.talkManager));
        manager.addStrategy(new RecordPdoResellerStrategy(this.misureDao, this.talkManager));
        return manager;
    }
}

