/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.reseller;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.reseller.FlussoReseller;
import java.util.List;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.ElaborCalendar;

public class GetSofResellerStrategy
implements ServiceStrategy {
    private final ElaborCalendar month;
    private final String prefix;
    private final MisureDao misureDao;

    public GetSofResellerStrategy(ElaborCalendar month, String prefix, MisureDao misureDao) {
        this.month = month;
        this.prefix = prefix;
        this.misureDao = misureDao;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        Logger logger = status.getLogger();
        logger.info("sof anno " + this.month.getAnno() + " mese " + (Object)((Object)this.month.getMese()) + " prefisso " + this.prefix);
        List<FlussoReseller> mno = this.misureDao.getSofNoReseller(this.month, this.prefix);
        status.setFlussiReseller(mno);
        logger.info("sof anno " + this.month.getAnno() + " mese " + (Object)((Object)this.month.getMese()) + " prefisso " + this.prefix + ": " + mno.size());
        return true;
    }
}

