/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.matricolefittizie;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.utils.ExportHelper;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.PodMatricola;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Snf;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.common.MatricoleHelper;
import biz.elabor.prebilling.web.matricolefittizie.PodGestito;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.listmap.ListMapKey;
import org.homelinux.elabor.structures.safe.SafeMap;

public class GestioneMatricoleStrategy
implements ServiceStrategy {
    private static final String TERM_DOS = "\r\n";
    private static final String LETTI = "letti";
    private static final String POD_GESTITI = "gestiti";
    private static final DateFormat OUTPUT_DATE_FORMAT = new SimpleDateFormat("ddMMyyyy");
    private PrebillingConfiguration configuration;
    private GiadaDao giadaDao;
    private TalkManager talkManager;
    private MisureDao misureDao;
    private String resellerCode;
    private final DateFormat timestampFormat;

    public GestioneMatricoleStrategy(PrebillingConfiguration configuration, GiadaDao giadaDao, MisureDao misureDao, TalkManager talkManager, String resellerCode) {
        this.configuration = configuration;
        this.giadaDao = giadaDao;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.resellerCode = resellerCode;
        this.timestampFormat = StrategyCommonHelper.getTimestampFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        List<PodMatricola> pods = this.giadaDao.getPodMatricolaFittizia(this.resellerCode);
        ListMapKey<String, PodGestito> podGestiti = this.buildPodGestiti(pods, status);
        String idEsecuzione = status.getIdEsecuzione();
        boolean ok = this.exportPodGestiti(podGestiti, idEsecuzione);
        try {
            ok &= this.updatePodGestiti(podGestiti, status);
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("gestione.matricole", message);
            String key = exc.getKey();
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private ListMapKey<String, PodGestito> buildPodGestiti(List<PodMatricola> pods, ServiceStatus status) {
        DefaultListMapKey<String, PodGestito> podGestiti = new DefaultListMapKey<String, PodGestito>();
        for (PodMatricola pod : pods) {
            String azienda = pod.getAzienda();
            status.count(azienda, LETTI, 1);
            String codicePod = pod.getCodice();
            Date date = pod.getData();
            String matrSnf = this.getMatrSnf(codicePod, date);
            String matricola = MatricoleHelper.buildMatricola(codicePod, date, matrSnf, this.giadaDao);
            if (matricola.isEmpty()) continue;
            PodGestito podGestito = new PodGestito(pod, matricola);
            podGestiti.add(podGestito);
            status.count(azienda, POD_GESTITI, 1);
        }
        return podGestiti;
    }

    private String getMatrSnf(String codicePod, Date date) {
        String matrSnf;
        try {
            Snf snf = this.misureDao.getSnf(codicePod, date, true);
            matrSnf = snf.getMatrAtt();
        }
        catch (DataNotFoundException e2) {
            matrSnf = "";
        }
        return matrSnf;
    }

    private boolean exportPodGestiti(ListMapKey<String, PodGestito> podGestiti, String idEsecuzione) {
        boolean ok = true;
        for (Map.Entry entry : podGestiti.entrySet()) {
            String azienda = (String)entry.getKey();
            List podGestitiAzienda = (List)entry.getValue();
            File folder = ConfigurationHelper.getResellerTmpImportFolder(this.configuration, idEsecuzione, azienda, Funzionalita.GESTIONE_MATRICOLE);
            String timestamp = this.timestampFormat.format(new Date());
            String fileName = "gestione-matricole-fittizie-" + azienda + "-" + timestamp + ".txt";
            File outFile = new File(folder, fileName);
            try {
                this.exoprtPodGestitiAzienda(podGestitiAzienda, outFile);
            }
            catch (FileNotFoundException exc) {
                Warning sentence = new Warning("get.applicazioni.strategy", "file.createFailed");
                sentence.setCss("alert-danger");
                sentence.addParam(fileName);
                this.talkManager.addSentence(sentence);
                ok = false;
            }
        }
        return ok;
    }

    private boolean updatePodGestiti(ListMapKey<String, PodGestito> podGestiti, ServiceStatus status) throws DataNotFoundException {
        SafeMap<String, Reseller> resellers = status.getResellers();
        boolean ok = true;
        for (Map.Entry entry : podGestiti.entrySet()) {
            String azienda = (String)entry.getKey();
            Reseller reseller = (Reseller)resellers.get(azienda);
            if (!reseller.isHandleStato()) continue;
            List podGestitiAzienda = (List)entry.getValue();
            for (PodGestito podGestito : podGestitiAzienda) {
                PodMatricola pod = podGestito.getPod();
                String codicePod = pod.getCodice();
                String fittizia = pod.getMatricola();
                String matricola = podGestito.getMatricola();
                this.misureDao.updateMatricolaStatoPod(codicePod, fittizia, matricola);
            }
        }
        return ok;
    }

    private void exoprtPodGestitiAzienda(List<PodGestito> podGestitiAzienda, File outFile) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(outFile);){
            GestioneMatricoleStrategy.printGestFile33Header(writer);
            int lunghezzaMatricola = this.configuration.getLunghezzaMatricola();
            for (PodGestito podGestito : podGestitiAzienda) {
                writer.print("%");
                String matricola = podGestito.getMatricola();
                PodMatricola podDate = podGestito.getPod();
                String codice = podDate.getCodice();
                Date data = podDate.getData();
                writer.print(ExportHelper.fixedLength(codice, 30));
                writer.print(OUTPUT_DATE_FORMAT.format(data));
                writer.print(ExportHelper.fixedLength(matricola, lunghezzaMatricola));
                writer.print(".");
                writer.print(TERM_DOS);
            }
        }
    }

    public static void printGestFile33Header(PrintWriter writer) {
        writer.print("@33");
        writer.print(ExportHelper.fixedLength("", 56));
        writer.print(".");
        writer.print(TERM_DOS);
    }
}

