/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.misure.model.TipoEnergia;
import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.utils.ExportHelper;
import biz.elabor.prebilling.common.utils.ListWriter;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.TrattamentoHandler;
import biz.elabor.prebilling.util.DefaultListWriter;
import biz.elabor.prebilling.util.MapWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;

public class WriteLetstdService {
    private static final DecimalFormat FORMATTER = new DecimalFormat("000000000.000");
    private static final String TAPPO = ".";
    private static final String FILLER = "      ";
    private static final String QTSCATTI = "000000000000";
    private static final String FLPREACC = "0";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("ddMMyyyy0000");
    private static final List<String> FLUSSI_ORARI = Arrays.asList("PDO", "PDO2G", "RFO", "RFO2G");
    private static final List<String> FLUSSI_RNV = Arrays.asList("rnv", "rnv2g");
    private static String codiceLettura = ExportHelper.fixedLength("", 15);
    private final String numMatric;
    private final String codicePod;
    private final PrebillingConfiguration configuration;

    public WriteLetstdService(String codicePod, PrebillingConfiguration configuration) {
        this.codicePod = codicePod;
        this.configuration = configuration;
        int lunghezzaMatricola = this.configuration.getLunghezzaMatricola();
        this.numMatric = ExportHelper.fixedLength("", lunghezzaMatricola);
    }

    public void write(List<? extends MisuraPod> misurePeriodo, MapWriter mapWriter, TrattamentoHandler handler, boolean forceFlusso) {
        DefaultListWriter listWriter = new DefaultListWriter();
        for (MisuraPod misuraPod : misurePeriodo) {
            this.write(misuraPod, listWriter, handler, forceFlusso);
        }
        mapWriter.append(this.codicePod, listWriter);
    }

    public void write(MisuraPod misuraPod, ListWriter listWriter, TrattamentoHandler handler, boolean forceFlusso) {
        String className = this.getClass().getSimpleName();
        Pod pod = misuraPod.getPod();
        PrebillingContext.setContext(className, "pod: " + pod.getCodice());
        Misura misura = misuraPod.getMisura();
        double ka = StrategyHelper.getK(misuraPod.getKa());
        double kr = StrategyHelper.getK(misuraPod.getKr());
        double kp = StrategyHelper.getK(misuraPod.getKp());
        misura.align(this.configuration, ka, kr, kp);
        Date dataMisura = misura.getDate();
        Date dataEfficace = CalendarTools.nextDay(dataMisura);
        String codiceFlusso = forceFlusso ? WriteLetstdService.getFlusso(pod, dataEfficace) : misuraPod.getCodiceFlusso();
        String regime = misuraPod.getRegime();
        boolean pdo2gr = misuraPod.isPdo2GR();
        boolean segnaliPod = !StrategyHelper.FLUSSI_POD_ORARI.contains(codiceFlusso) || !regime.equals("R") || pdo2gr;
        handler.write(this, listWriter, misuraPod, codiceFlusso, segnaliPod);
    }

    private static String getFlusso(Pod pod, Date dataEfficace) {
        return pod.isPodNuovo(dataEfficace) ? "rsnf" : "rnvf";
    }

    public void writeMono(ListWriter writer, MisuraPod misuraPod, String flusso) {
        Pod pod = misuraPod.getPod();
        Misura misura = misuraPod.getMisura();
        Date data = misura.getDate();
        boolean orario = pod.isAzzeramento(data);
        boolean stimata = misura.isStimata();
        boolean attiva = pod.isMisuraAttiva(data);
        boolean reattiva = this.checkReattiva(pod, data);
        boolean potenza = pod.isMisuraPotenza(data);
        boolean commerciale = misura.hasCommerciale();
        double attivaMono = misura.getAttiva(FasciaOraria.F1).getNetto();
        double reattivaMono = misura.getReattiva(FasciaOraria.F1).getNetto();
        double potenzaMono = misura.getPotenza(FasciaOraria.F1).getNetto();
        String cdMesLet = this.getCdMesLet(flusso, stimata, orario, false, false);
        if (attiva && !reattiva && !potenza) {
            String riga = this.createUserData(attiva, reattiva, potenza, commerciale, attivaMono, 1, data, cdMesLet);
            writer.print(riga, "\r\n");
        } else {
            double[] last;
            String riga = this.createUserData(attiva, reattiva, potenza, commerciale, 0.0, 1, data, cdMesLet);
            writer.print(riga, "\r\n");
            if (attiva) {
                last = pod.getLastAttiva();
                riga = this.createRecordLine(TipoEnergia.ATTIVA, attivaMono, 0.0, 0.0, last[0], 0.0, 0.0);
                writer.print(riga, "\r\n");
            }
            if (reattiva) {
                last = pod.getLastReattiva();
                riga = this.createRecordLine(TipoEnergia.REATTIVA, reattivaMono, 0.0, 0.0, last[0], 0.0, 0.0);
                writer.print(riga, "\r\n");
            }
            if (potenza) {
                riga = this.createRecordLine(TipoEnergia.POTENZA, potenzaMono, 0.0, 0.0, potenzaMono, 0.0, 0.0);
                writer.print(riga, "\r\n");
            }
        }
    }

    public void writeFasce(ListWriter writer, MisuraPod misuraPod, String flusso) {
        Pod pod = misuraPod.getPod();
        Misura misura = misuraPod.getMisura();
        Date date = misura.getDate();
        boolean attiva = pod.isMisuraAttiva(date);
        boolean reattiva = this.checkReattiva(pod, date);
        boolean potenza = pod.isMisuraPotenza(date);
        this.write(writer, misuraPod, attiva, reattiva, potenza, flusso);
    }

    public void writeOrario(ListWriter writer, MisuraPod misuraPod, String flusso, boolean segnaliPod) {
        Pod pod = misuraPod.getPod();
        Misura misura = misuraPod.getMisura();
        Date dataMisura = misura.getDate();
        boolean attiva = segnaliPod ? pod.isMisuraAttiva(dataMisura) : true;
        boolean reattiva = segnaliPod ? this.checkReattiva(pod, dataMisura) : true;
        boolean potenza = segnaliPod ? pod.isMisuraPotenza(dataMisura) : true;
        this.write(writer, misuraPod, attiva, reattiva, potenza, flusso);
    }

    private void write(ListWriter writer, MisuraPod misuraPod, boolean attiva, boolean reattiva, boolean potenza, String flusso) {
        double[] last;
        double attivaF3;
        double attivaF2;
        double attivaF1;
        Pod pod = misuraPod.getPod();
        Misura misura = misuraPod.getMisura();
        Date data = misuraPod.getDataMisura();
        boolean orario = FLUSSI_ORARI.contains(misura.getCodiceFlusso().toUpperCase());
        boolean azzeramento = pod.isAzzeramento(data);
        boolean stimata = misura.isStimata();
        boolean commerciale = misura.hasCommerciale();
        int fasce = misuraPod.isForfait() ? 1 : misura.getFasce();
        Date dataMax = pod.getDataMax();
        boolean rettifica = !data.after(dataMax) || StrategyHelper.MOROSITA.contains(flusso.toUpperCase());
        String regime = misuraPod.getRegime();
        String flCdMesLet = FLUSSI_RNV.contains(flusso.toLowerCase()) && pod.isPodNuovo(data) ? "rnv_iv" : String.valueOf(flusso) + regime;
        boolean smis = misuraPod.isSmis();
        String cdmeslet = this.getCdMesLet(flCdMesLet, stimata, orario, rettifica, smis);
        String riga = this.createUserData(attiva, reattiva, potenza, commerciale, 0.0, fasce, data, cdmeslet);
        writer.print(riga, "\r\n");
        if (attiva) {
            attivaF1 = misura.getAttiva(FasciaOraria.F1).getNetto();
            attivaF2 = misura.getAttiva(FasciaOraria.F2).getNetto();
            attivaF3 = misura.getAttiva(FasciaOraria.F3).getNetto();
            last = pod.getLastAttiva();
            double lastF1 = azzeramento ? 0.0 : last[0];
            double lastF2 = azzeramento ? 0.0 : last[1];
            double lastF3 = azzeramento ? 0.0 : last[2];
            riga = this.createRecordLine(TipoEnergia.ATTIVA, attivaF1, attivaF2, attivaF3, lastF1, lastF2, lastF3);
            writer.print(riga, "\r\n");
        }
        if (reattiva) {
            double reattivaF1 = misura.getReattiva(FasciaOraria.F1).getNetto();
            double reattivaF2 = misura.getReattiva(FasciaOraria.F2).getNetto();
            double reattivaF3 = misura.getReattiva(FasciaOraria.F3).getNetto();
            last = pod.getLastReattiva();
            riga = this.createRecordLine(TipoEnergia.REATTIVA, reattivaF1, reattivaF2, reattivaF3, last[0], last[1], last[2]);
            writer.print(riga, "\r\n");
        }
        if (potenza) {
            double potenzaF1 = misura.getPotenza(FasciaOraria.F1).getNetto();
            double potenzaF2 = misura.getPotenza(FasciaOraria.F2).getNetto();
            double potenzaF3 = misura.getPotenza(FasciaOraria.F3).getNetto();
            riga = this.createRecordLine(TipoEnergia.POTENZA, potenzaF1, potenzaF2, potenzaF3, potenzaF1, potenzaF2, potenzaF3);
            writer.print(riga, "\r\n");
        }
        if (misura.hasCommerciale()) {
            attivaF1 = misura.getCommerciale(FasciaOraria.F1).getNetto();
            attivaF2 = misura.getCommerciale(FasciaOraria.F2).getNetto();
            attivaF3 = misura.getCommerciale(FasciaOraria.F3).getNetto();
            riga = this.createRecordLine(TipoEnergia.COMMERCIALE, attivaF1, attivaF2, attivaF3, 0.0, 0.0, 0.0);
            writer.print(riga, "\r\n");
        }
    }

    private String createUserData(boolean attiva, boolean reattiva, boolean potenza, boolean commerciale, double value, int fasce, Date data, String cdmeslet) {
        String segnale = String.valueOf(WriteLetstdService.getSegnale(attiva, reattiva, potenza, commerciale)) + String.valueOf(fasce);
        String cdute = ExportHelper.fixedLength("1" + this.codicePod, 17);
        String line = "%" + ExportHelper.fixedLength(this.codicePod, 14) + cdute + segnale + DATE_FORMAT.format(data) + WriteLetstdService.getFormattedValue(value) + ExportHelper.fixedLength(cdmeslet, 4) + codiceLettura + WriteLetstdService.getFormattedValue(0.0) + this.numMatric + FLPREACC + FILLER + TAPPO;
        return line;
    }

    private String createRecordLine(TipoEnergia tipoEnergia, double value1, double value2, double value3, double last1, double last2, double last3) {
        double exportValue1 = WriteLetstdService.checkValue(value1, last1);
        double exportValue2 = WriteLetstdService.checkValue(value2, last2);
        double exportValue3 = WriteLetstdService.checkValue(value3, last3);
        return "$" + WriteLetstdService.getTipoMisura(tipoEnergia) + this.numMatric + WriteLetstdService.getFormattedValue(exportValue1) + QTSCATTI + WriteLetstdService.getFormattedValue(exportValue2) + QTSCATTI + WriteLetstdService.getFormattedValue(exportValue3) + QTSCATTI + WriteLetstdService.getFormattedValue(0.0) + QTSCATTI + " " + TAPPO;
    }

    private String getCdMesLet(String flusso, boolean stimata, boolean orario, boolean rettifica, boolean smis) {
        return this.configuration.getCdmeslet(flusso, stimata, orario, rettifica, smis);
    }

    private static String getSegnale(boolean attiva, boolean reattiva, boolean potenza, boolean bioraria) {
        return String.valueOf(attiva ? "1" : FLPREACC) + (reattiva ? "1" : FLPREACC) + (potenza ? "1" : FLPREACC) + FLPREACC + (bioraria ? "3" : FLPREACC);
    }

    private static String getFormattedValue(double value) {
        String string = FORMATTER.format(value);
        return String.valueOf(string.substring(0, 9)) + string.substring(10);
    }

    private static double checkValue(double value, double last) {
        return value < last - 1.0 || value > last ? value : last;
    }

    private static String getTipoMisura(TipoEnergia tipoEnergia) {
        return FLPREACC + String.valueOf(tipoEnergia.ordinal() + 1);
    }

    private boolean checkReattiva(Pod pod, Date date) {
        Set<String> tarDisDom = this.configuration.getTarDisDom();
        return pod.isMisuraReattiva(date) && (!pod.isAllineato() || !StrategyHelper.checkReattiva(pod, tarDisDom));
    }
}

