/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.InvalidFasciaValue;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.letture.AbstractPivChecker;
import biz.elabor.prebilling.services.letture.BaseAggregationStrategy;
import biz.elabor.prebilling.services.letture.ExportLetturePeriodoStrategy;
import biz.elabor.prebilling.services.letture.IncoherenceException;
import biz.elabor.prebilling.services.letture.MisuraNonZeroException;
import biz.elabor.prebilling.services.letture.PodNonorarioException;
import org.homelinux.elabor.db.DataNotFoundException;

public class PivExistsChecker
extends AbstractPivChecker {
    private boolean checkOutDate = true;

    @Override
    public void handlePdo(Pdo pdo, StatusTransaction transaction, BaseAggregationStrategy baseStrategy) throws PodNonorarioException, DataNotFoundException, CalendarNotFoundException, IncoherenceException, StatoPodCheckException, PraticaAnnullataException, MisuraNonZeroException, InvalidFasciaValue {
        String codicePod = pdo.getCodicePod();
        PraticaVolo pratica = PivExistsChecker.getVirtualPiv(codicePod, transaction);
        if (pratica != null) {
            baseStrategy.handlePdo(pdo, pratica, transaction);
        }
    }

    @Override
    public void write(MnoPod mnoPod, ServiceStatus status, ExportLetturePeriodoStrategy baseStrategy) throws CalendarNotFoundException {
        String codicePod = mnoPod.getKey();
        try {
            PraticaVolo pratica = StrategyHelper.getPiv(codicePod, null, status);
            String codicePrestazione = pratica.getCodicePrestazione();
            this.checkOutDate = !codicePrestazione.equalsIgnoreCase("COF");
            baseStrategy.write(mnoPod, status);
        }
        catch (DataNotFoundException dataNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public String getId() {
        return "piv";
    }

    @Override
    public boolean isPiv() {
        return true;
    }

    @Override
    public boolean isCheckOutDate() {
        return this.checkOutDate;
    }
}

