/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.MisureAzienda;
import biz.elabor.prebilling.services.letture.MisureOrarieEnvironment;
import biz.elabor.prebilling.services.volture.ExtMno;
import java.util.Collection;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.safe.SafeMap;

public class PdoEnvironment
implements MisureOrarieEnvironment {
    private final Pod pod;
    private final Pdo pdo;
    private final MappaMisureAzienda pnos;
    private final PraticaVolo pratica;

    public PdoEnvironment(Pod pod, Pdo pdo, MappaMisureAzienda pnos, PraticaVolo pratica) {
        this.pod = pod;
        this.pdo = pdo;
        this.pnos = pnos;
        this.pratica = pratica;
    }

    @Override
    public Date getDataMisuraSmis() {
        return this.pnos.getDataMisuraPrestazione(this.pod);
    }

    @Override
    public boolean isSwitchout() {
        return PdoEnvironment.isSwitchout(this.pod, this.pdo);
    }

    @Override
    public boolean isRettifica() {
        return false;
    }

    @Override
    public boolean isBlockingSmis() {
        return PdoEnvironment.isBlockingSmis(this.pod, this.pnos);
    }

    @Override
    public boolean isPiv() {
        return this.pratica != null;
    }

    private static boolean isSwitchout(Pod pod, Pdo pdo) {
        RilMese rilMese = pdo.getRilMese();
        int anno = rilMese.getAnno();
        Month mese = rilMese.getMese();
        Date switchOutDate = pod.getSwitchout();
        boolean ok = false;
        if (switchOutDate != null) {
            ElaborCalendar calendar = new ElaborCalendar(switchOutDate);
            int switchAnno = calendar.getAnno();
            Month switchMese = calendar.getMese();
            ok = anno == switchAnno && mese == switchMese;
        }
        return ok;
    }

    private static boolean isBlockingSmis(Pod pod, MappaMisureAzienda pnos) {
        boolean blockingSmis;
        String azienda = pod.getAzienda();
        MisureAzienda misureAzienda = (MisureAzienda)pnos.get(azienda);
        if (misureAzienda == null) {
            blockingSmis = false;
        } else {
            try {
                SafeMap<String, MnoPod> misure = misureAzienda.getMisure();
                String codicePod = pod.getCodice();
                MnoPod mnoPod = (MnoPod)misure.get(codicePod);
                Collection<ExtMno> smis = mnoPod.getSmis();
                blockingSmis = !smis.isEmpty();
            }
            catch (DataNotFoundException exc) {
                blockingSmis = false;
            }
        }
        return blockingSmis;
    }

    @Override
    public boolean isBlocked() {
        return this.isPiv() && this.isBlockingSmis();
    }

    @Override
    public SpecificaTecnica getSpecificaVoltura() {
        String prestazione;
        SpecificaTecnica voltura = new SpecificaTecnica(null, null);
        if (this.isPiv() && StrategyHelper.VOLTURE_CDUNIPRE_LIST.contains(prestazione = this.pratica.getCodicePrestazione())) {
            voltura = this.pratica.getSpecificaTecnica();
        }
        return voltura;
    }

    @Override
    public Date getDataMisuraPrestazione() {
        Date dataMisuraPrestazione = this.getDataMisuraSmis();
        if (this.pratica != null) {
            Date dataTecnica = this.pratica.getSpecificaTecnica().getData();
            Date dataCommerciale = this.pratica.getDataCommerciale();
            Date dataPratica = CalendarTools.min(dataTecnica, dataCommerciale);
            Date dataMisuraPratica = CalendarTools.previousDay(dataPratica);
            dataMisuraPrestazione = CalendarTools.min(dataMisuraPratica, dataMisuraPrestazione);
        }
        return dataMisuraPrestazione;
    }
}

