/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.letture.MisuraMno;
import java.util.Date;

public class MisuraGiada
extends MisuraMno {
    private final Misura misura;

    public MisuraGiada(Pod pod, Mno mno) {
        super(pod, mno);
        Date date = this.getDataMisura();
        String codiceFlusso = mno.getCodiceFlusso();
        this.misura = new Misura(date, false, 3, codiceFlusso);
        double[] lastAttiva = pod.getLastAttiva();
        double[] lastReattiva = pod.getLastReattiva();
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double value = lastAttiva[fascia.ordinal()];
            this.misura.setAttiva(fascia, value, 0.0);
            value = lastReattiva[fascia.ordinal()];
            this.misura.setReattiva(fascia, value, 0.0);
            ++n3;
        }
    }

    @Override
    public String getKaSegnale() {
        Date dataMisura = this.getDataMisura();
        return String.valueOf(this.pod.getKa(dataMisura));
    }

    @Override
    public String getKrSegnale() {
        Date dataMisura = this.getDataMisura();
        return String.valueOf(this.pod.getKr(dataMisura));
    }

    @Override
    public String getKpSegnale() {
        Date dataMisura = this.getDataMisura();
        return String.valueOf(this.pod.getKp(dataMisura));
    }

    @Override
    public Misura getMisura() {
        return this.misura;
    }
}

