/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.TipoLetStd;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.GruppoFlussi;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.TrattamentoHandler;
import biz.elabor.prebilling.services.letture.WriteLetstdService;
import biz.elabor.prebilling.util.DefaultListWriter;
import biz.elabor.prebilling.util.MapWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class LetturePrestazioneStrategy
implements ServiceStrategy {
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final PrebillingConfiguration configuration;
    private final Date endOfTime = CalendarTools.getEndOfTime();
    private static final List<String> FLUSSI = new ArrayList<String>();

    static {
        FLUSSI.addAll(MappaMisureAzienda.FLUSSI_ATTIVAZIONE);
        FLUSSI.addAll(MappaMisureAzienda.FLUSSI_VARIAZIONE_POTENZA);
    }

    public LetturePrestazioneStrategy(MisureDao misureDao, TalkManager talkManager, PrebillingConfiguration configuration) {
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.configuration = configuration;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        Map<Date, Map<String, ListMap<GruppoFlussi, Mno>>> letture = status.getMisurePrestazioni();
        for (Map.Entry<Date, Map<String, ListMap<GruppoFlussi, Mno>>> entryData : letture.entrySet()) {
            Date dataPrestazione = entryData.getKey();
            Map<String, ListMap<GruppoFlussi, Mno>> letturePod = entryData.getValue();
            for (Map.Entry<String, ListMap<GruppoFlussi, Mno>> entryPod : letturePod.entrySet()) {
                String codicePod = entryPod.getKey();
                ListMap<GruppoFlussi, Mno> lettureFlusso = entryPod.getValue();
                for (Map.Entry entryFlusso : lettureFlusso.entrySet()) {
                    GruppoFlussi gruppo = (GruppoFlussi)((Object)entryFlusso.getKey());
                    if (!this.misureElaborate(codicePod, gruppo, dataPrestazione)) continue;
                    List mnos = (List)entryFlusso.getValue();
                    try {
                        this.handleMisure(status, mnos);
                    }
                    catch (DataNotFoundException exc) {
                        String message = exc.getMessage();
                        Message sentence = new Message(Funzionalita.LETTURE.name(), message);
                        sentence.addParam(exc.getKey());
                        this.talkManager.addSentence(sentence);
                        String descrizione = this.talkManager.getMessage(sentence);
                        status.addMnoSospesi(mnos, ErroriElaborazione.POD_NOTFOUND, descrizione, this.endOfTime);
                    }
                }
            }
        }
        return true;
    }

    public void handleMisure(ServiceStatus status, List<Mno> mnos) throws DataNotFoundException {
        List<Mno> obsoleti;
        Mno head = mnos.get(0);
        PodMap podMap = status.getPodMap();
        String codicePod = head.getCodicePod();
        Pod pod = podMap.get(codicePod);
        String reseller = pod.getAzienda();
        head.setCdaziend(reseller);
        String codiceFlusso = head.getCodiceFlusso();
        if (codiceFlusso.startsWith("AVR") || codiceFlusso.startsWith("VPR")) {
            this.handleRettifica(pod, head, status);
            obsoleti = mnos.subList(1, mnos.size());
        } else {
            obsoleti = mnos;
        }
        StrategyHelper.addMnoObsoleti(obsoleti, reseller, status, this.talkManager);
    }

    private void handleRettifica(Pod pod, Mno mno, ServiceStatus status) {
        String codicePod = mno.getCodicePod();
        WriteLetstdService service = new WriteLetstdService(codicePod, this.configuration);
        Date dataPrestazione = mno.getDataPrestazione();
        Date fixDataMisura = CalendarTools.previousDay(dataPrestazione);
        MisuraMno misuraPod = new MisuraMno(pod, mno, fixDataMisura);
        DefaultListWriter listWriter = new DefaultListWriter();
        Trattamento trattamento = mno.getTrattamento();
        TrattamentoHandler handler = trattamento.getHandler();
        service.write(misuraPod, listWriter, handler, false);
        MapWriter mapWriter = status.getMisureDispatcherWriter(TipoLetStd.RETT);
        mapWriter.append(codicePod, listWriter);
        MnoResult result = new MnoResult(mno, ErroriElaborazione.OK, "");
        status.addPnoElaborato(result);
        String codiceFlusso = mno.getCodiceFlusso();
        String azienda = pod.getAzienda();
        status.count(azienda, codiceFlusso, 1);
        status.addLettura(misuraPod);
    }

    private boolean misureElaborate(String codicePod, GruppoFlussi gruppo, Date dataPratica) {
        List<Mno> elaborate = this.misureDao.getMnoPrestazione(codicePod, dataPratica, StrategyHelper.ELABORATO, gruppo.getFlussi());
        return !elaborate.isEmpty();
    }
}

