/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;

class LateProcessingPTH
implements PraticaTardivaHandler {
    LateProcessingPTH() {
    }

    @Override
    public Mno getPnoPraticaTardiva(String codicePod, Date dataPratica, int scostamento, Iterable<String> tipiDato, MisureDao misureDao) throws DataNotFoundException {
        return misureDao.getPnoLateProcessing(codicePod, dataPratica, scostamento, tipiDato);
    }

    @Override
    public Mno getPnoCP1Tardiva(String codicePod, Date dataPratica, Iterable<String> tipiDato, MisureDao misureDao) throws DataNotFoundException {
        return misureDao.getPnoCP1LateProcessing(codicePod, dataPratica, tipiDato);
    }

    @Override
    public Mno getPdo2GRPraticaTardiva(String codicePod, Date dataPratica, int scostamento, Iterable<String> tipiDato, MisureDao misureDao) throws DataNotFoundException {
        return misureDao.getPdo2GRLateProcessing(codicePod, dataPratica, scostamento, tipiDato);
    }

    @Override
    public Mno getPdo2GRCP1Tardiva(String codicePod, Date dataPratica, Iterable<String> tipiDato, MisureDao misureDao) throws DataNotFoundException {
        return misureDao.getPdo2GRCP1LateProcessing(codicePod, dataPratica, tipiDato);
    }

    @Override
    public Mno buildMnoFromPod(Pod pod, Date dataPratica) {
        String azienda = pod.getAzienda();
        String codicePod = pod.getCodice();
        HashMap<String, Map<String, String>> datiPod = new HashMap<String, Map<String, String>>();
        HashMap<String, String> datiPdp = new HashMap<String, String>();
        datiPdp.put("Tensione", String.valueOf(pod.getTensione()));
        datiPod.put("DatiPdp", datiPdp);
        HashMap<String, String> misuraPod = new HashMap<String, String>();
        misuraPod.put("TipoDato", "E");
        datiPod.put("Misura", misuraPod);
        Misura misura = new Misura(null, false, 3, "GIADA");
        double[] attiva = pod.getLastAttiva();
        double[] reattiva = pod.getLastReattiva();
        DecimalFormat format = StrategyHelper.getUsEnergyFormat();
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            String fasciaName = fascia.name();
            int fasciaOrdinal = fascia.ordinal();
            double attivaFascia = attiva[fasciaOrdinal];
            misura.setAttiva(fascia, attivaFascia, 0.0);
            misuraPod.put("Ea" + fasciaName, format.format(attivaFascia));
            double reattivaFascia = reattiva[fasciaOrdinal];
            misura.setReattiva(fascia, reattivaFascia, 0.0);
            misuraPod.put("Er" + fasciaName, format.format(reattivaFascia));
            misura.setPotenza(fascia, 0.0, 0.0);
            misuraPod.put("Pot" + fasciaName, "0");
            ++n3;
        }
        String pIvaDistributore = pod.getPivaDistributore(dataPratica);
        String pIvaUtente = pod.getPivaDispatcher(dataPratica);
        String codContrDisp = pod.getDispatcher();
        return new Mno("0", "GIADA", codicePod, misura, pIvaUtente, pIvaDistributore, codContrDisp, null, azienda, null, null, datiPod, null, null, null, null, null, null, null, null, null, null, null, StatoMisure.VALIDATO, null, false, null, false, false, null);
    }
}

