/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.exceptions.BasicKeyException;

public class IncoherentTrattamentoException
extends BasicKeyException {
    private static final long serialVersionUID = 1L;
    private static final ErroriElaborazione ERROR = ErroriElaborazione.INCOHERENT_TRATTAMENTO;
    private final Date dataMisuraPrec;
    private final Date dataMisura;

    public Date getDataMisuraPrec() {
        return this.dataMisuraPrec;
    }

    public Date getDataMisura() {
        return this.dataMisura;
    }

    public IncoherentTrattamentoException(String codicePod, Date dataMisuraPrec, Date dataMisura) {
        super(ERROR.getMessage(), codicePod, ERROR.ordinal());
        this.dataMisuraPrec = dataMisuraPrec;
        this.dataMisura = dataMisura;
    }

    @Override
    public List<String> getParams() {
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.key);
        params.add(dateFormat.format(this.dataMisuraPrec));
        params.add(dateFormat.format(this.dataMisura));
        return params;
    }
}

