/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.services.letture.GetSmisStrategy;
import biz.elabor.prebilling.services.letture.GetSmisStrategyMockMisureDao;
import biz.elabor.prebilling.services.letture.MisureAzienda;
import biz.elabor.prebilling.services.letture.PrebillingTestHelper;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.safe.SafeMap;

public class GetSmisStrategyTest
extends TestCase {
    public void testExecute() throws DataNotFoundException {
        TestConfiguration configuration = new TestConfiguration();
        TestServiceStatus status = new TestServiceStatus(configuration);
        DefaultPodMap pods = new DefaultPodMap();
        Pod pod = new Pod("pod", false, 0, "azienda", null, null, true, true, true, null, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
        pods.add(pod);
        status.setPodMap(pods);
        MappaMisureAzienda pnos = new MappaMisureAzienda(TipoEstrazione.TUTTI, null, null, null);
        status.setPno(pnos);
        GetSmisStrategyMockMisureDao misureDao = new GetSmisStrategyMockMisureDao();
        TalkManager talkManager = new TalkManager();
        GetSmisStrategy strategy = new GetSmisStrategy(2020, Month.JULY, null, TipoEstrazione.TUTTI, "", misureDao, talkManager);
        DefaultListMapKey<String, Mno> smis = new DefaultListMapKey<String, Mno>();
        misureDao.setSmis(smis);
        strategy.execute(status);
        pnos = status.getPnos();
        GetSmisStrategyTest.assertEquals(0, pnos.size());
        pnos = new MappaMisureAzienda(TipoEstrazione.TUTTI, null, null, misureDao);
        status.setPno(pnos);
        Misura misuraS = PrebillingTestHelper.newMisura(CalendarTools.getDate(2020, Month.APRIL, 21), false, 3);
        smis = new DefaultListMapKey();
        smis.add(new Mno(null, null, "pod", misuraS, null, null, null, null, null, null, null, null, "", "", null, null, null, "", "", null, ""));
        misureDao.setSmis(smis);
        strategy.execute(status);
        pnos = status.getPnos();
        GetSmisStrategyTest.assertEquals(0, pnos.size());
        pnos = new MappaMisureAzienda(TipoEstrazione.TUTTI, null, null, misureDao);
        status.setPno(pnos);
        smis = new DefaultListMapKey();
        HashMap<String, Map<String, String>> datipodSmontaggio = new HashMap<String, Map<String, String>>();
        datipodSmontaggio.put("DatiPdp", new HashMap());
        HashMap<String, String> misuraSmontaggio = new HashMap<String, String>();
        misuraSmontaggio.put("Raccolta", "S");
        datipodSmontaggio.put("Misura", misuraSmontaggio);
        HashMap<String, Map<String, String>> datipodMontaggio = new HashMap<String, Map<String, String>>();
        datipodMontaggio.put("DatiPdp", new HashMap());
        HashMap<String, String> misuraMontaggio = new HashMap<String, String>();
        misuraMontaggio.put("Raccolta", "M");
        datipodMontaggio.put("Misura", misuraMontaggio);
        smis.add(new Mno(null, null, "pod", misuraS, null, null, "dispatcher", null, null, null, null, datipodSmontaggio, "", "", null, null, null, "", "", null, ""));
        Misura misuraM = PrebillingTestHelper.newMisura(CalendarTools.getDate(2020, Month.APRIL, 22), false, 3);
        smis.add(new Mno(null, null, "pod", misuraM, null, null, null, null, null, null, null, datipodMontaggio, "", "", null, null, null, "", "", null, ""));
        misureDao.setSmis(smis);
        strategy.execute(status);
        pnos = status.getPnos();
        GetSmisStrategyTest.assertEquals(1, pnos.size());
        SafeMap<String, MnoPod> misure = ((MisureAzienda)pnos.get("azienda")).getMisure();
        GetSmisStrategyTest.assertEquals(1, misure.size());
        GetSmisStrategyTest.assertEquals(2, ((MnoPod)misure.get("pod")).getSmis().size());
        pnos = new MappaMisureAzienda(TipoEstrazione.TUTTI, null, null, misureDao);
        status.setPno(pnos);
        smis = new DefaultListMapKey();
        smis.add(new Mno(null, null, "pod", misuraS, null, null, "dispatcher", null, null, null, null, datipodSmontaggio, "", "", null, null, null, "", "", null, ""));
        smis.add(new Mno(null, null, "pod", misuraM, null, null, null, null, null, null, null, datipodSmontaggio, "", "", null, null, null, "", "", null, ""));
        misureDao.setSmis(smis);
        strategy.execute(status);
        pnos = status.getPnos();
        GetSmisStrategyTest.assertEquals(0, pnos.size());
        pnos = new MappaMisureAzienda(TipoEstrazione.TUTTI, null, null, misureDao);
        status.setPno(pnos);
        smis = new DefaultListMapKey();
        smis.add(new Mno(null, null, "pod", misuraS, null, null, "dispatcher", null, null, null, null, datipodSmontaggio, "", "", null, null, null, "", "", null, ""));
        smis.add(new Mno(null, null, "pod", misuraM, null, null, null, null, null, null, null, datipodMontaggio, "", "", null, null, null, "", "", null, ""));
        Misura misuraX = PrebillingTestHelper.newMisura(CalendarTools.getDate(2020, Month.APRIL, 22), false, 3);
        smis.add(new Mno(null, null, "pod", misuraX, null, null, null, null, null, null, null, datipodMontaggio, "", "", null, null, null, "", "", null, ""));
        misureDao.setSmis(smis);
        strategy.execute(status);
        pnos = status.getPnos();
        GetSmisStrategyTest.assertEquals(1, pnos.size());
        misure = ((MisureAzienda)pnos.get("azienda")).getMisure();
        GetSmisStrategyTest.assertEquals(1, misure.size());
        GetSmisStrategyTest.assertEquals(2, ((MnoPod)misure.get("pod")).getSmis().size());
    }
}

