/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.ConfigurationHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.services.ServiceStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.safe.RecordSafeListMap;

public class ExportLogSostituzioniStrategy
implements ServiceStrategy {
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private int anno;
    private Month mese;
    private PrebillingConfiguration configuration;
    private TalkManager talkManager;

    public ExportLogSostituzioniStrategy(int anno, Month mese, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.configuration = configuration;
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        RecordSafeListMap<String, Pdo> pdos = status.getPdoMap();
        MappaMisureAzienda pnos = status.getPnos();
        ArrayList<String> codici = new ArrayList<String>();
        try {
            for (List list : pdos) {
                this.findToExport(list, pnos, codici);
            }
            String string = status.getIdEsecuzione();
            this.export(codici, string);
            ok = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Warning sentence = new Warning("export.sostituzioni.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(fileNotFoundException.getMessage());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    public void findToExport(Iterable<Pdo> pdos, MappaMisureAzienda pnos, List<String> codici) {
        for (Pdo pdo : pdos) {
            String codice = pdo.getCodicePod();
            PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codice);
            if (!pnos.containsPod(codice)) continue;
            codici.add(codice);
        }
    }

    public void export(List<String> codici, String idEsecuzione) throws FileNotFoundException {
        if (!codici.isEmpty()) {
            File folder = ConfigurationHelper.getDispatcherTmpLettureFolder(this.configuration, idEsecuzione, Funzionalita.LETTURE);
            Date now = new Date();
            String fileName = "sostituzioni-" + this.anno + "-" + this.mese.getIndex() + "-" + TIME_FORMAT.format(now) + ".txt";
            File file = new File(folder, fileName);
            PrintWriter writer = new PrintWriter(file);
            for (String codice : codici) {
                writer.println(String.valueOf(codice) + ";" + this.anno + "-" + this.mese.getIndex());
            }
            writer.close();
        }
    }
}

