/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.MisuraException;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.TipoLetStd;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.ExtendedLT;
import biz.elabor.prebilling.model.misure.InvalidFasciaValue;
import biz.elabor.prebilling.model.misure.MappaMisureAzienda;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisureHelper;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.MnoPod;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.DuplicatePivException;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.LetstdPrintMapWriter;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.SwitchoutHelper;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.common.statopod.PnoSwitchoutStatoPodHandler;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodCheckException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.CheckVolturaHandler;
import biz.elabor.prebilling.services.letture.CheckVolturaPdo2GHandler;
import biz.elabor.prebilling.services.letture.CheckVolturaPnoHandler;
import biz.elabor.prebilling.services.letture.IncoherentTrattamentoException;
import biz.elabor.prebilling.services.letture.MisuraGiada;
import biz.elabor.prebilling.services.letture.MisuraHandler;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.MisuraNotAlignedException;
import biz.elabor.prebilling.services.letture.MisuraObsoletaSmisException;
import biz.elabor.prebilling.services.letture.MisureAzienda;
import biz.elabor.prebilling.services.letture.Pdo2GRMisuraHandler;
import biz.elabor.prebilling.services.letture.PivChecker;
import biz.elabor.prebilling.services.letture.PnoMisuraHandler;
import biz.elabor.prebilling.services.letture.PnoObsoletoException;
import biz.elabor.prebilling.services.letture.statopod.RnoStatoPodHandler;
import biz.elabor.prebilling.services.tariffe.CalendarException;
import biz.elabor.prebilling.services.tariffe.SmisException;
import biz.elabor.prebilling.services.tariffe.TariffeHelper;
import biz.elabor.prebilling.services.volture.ExtMno;
import biz.elabor.prebilling.services.xml.TipoFlusso;
import biz.elabor.prebilling.util.MapWriter;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.Pair;
import org.homelinux.elabor.arrays.ArrayHelper;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.exceptions.BasicKeyException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.homelinux.elabor.structures.TappoIterator;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class ExportLetturePeriodoStrategy
implements ServiceStrategy {
    private static final String SERVIZIO = "E";
    private static final List<String> FLUSSI = Arrays.asList("PNO", "PNO2G", "PDO2G");
    private static final List<TipoPrestazione> TIPI_VOLTURA = Arrays.asList(TipoPrestazione.VT1_3, TipoPrestazione.VT3);
    private static final List<String> SMRT = Arrays.asList("SM", "RT");
    private final int anno;
    private final Month mese;
    protected final TalkManager talkManager;
    private final PnoSwitchoutStatoPodHandler statoPodHandler;
    private final PivChecker pivChecker;
    private final PrebillingConfiguration configuration;
    private final MisureDao misureDao;
    private final Date timestamp;
    private final DecimalFormat doubleFormat;
    private final DateFormat dateFormat;

    public ExportLetturePeriodoStrategy(int anno, Month mese, PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager, PivChecker pivChecker, Date timestamp) {
        this.configuration = configuration;
        this.anno = anno;
        this.mese = mese;
        this.talkManager = talkManager;
        this.statoPodHandler = new PnoSwitchoutStatoPodHandler(misureDao);
        this.pivChecker = pivChecker;
        this.misureDao = misureDao;
        this.timestamp = timestamp;
        this.doubleFormat = BasicRecordCreatorHelper.getDoubleFormat();
        this.dateFormat = StrategyHelper.getDataFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        boolean ok;
        try {
            SafeListMap<String, Prestazione> prestazioni = status.getPrestazioni();
            this.statoPodHandler.check(prestazioni);
            this.write(status);
            this.writeRiconfigurazioni(status);
            this.print(status);
            ok = true;
        }
        catch (FileNotFoundException exc) {
            Warning sentence = new Warning("export.stdlet.strategy", "file.createFailed");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getMessage());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (SegnaleNotHandledException exc) {
            Warning sentence = new Warning("export.stdlet.strategy", "segnale.nothandled");
            sentence.setCss("alert-danger");
            Prestazione prestazione = exc.getPrestazione();
            sentence.addParam(prestazione.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (PrestazioneNotFoundException exc) {
            Warning sentence = new Warning("export.stdlet.strategy", "prestazione.notfound");
            sentence.setCss("alert-danger");
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        catch (CalendarNotFoundException exc) {
            String message = exc.getMessage();
            Message sentence = new Message("export.stdlet.strategy", message);
            sentence.addParam(exc.getKey());
            sentence.addParam(exc.getCodicePod());
            this.talkManager.addSentence(sentence);
            ok = false;
        }
        return ok;
    }

    private void writeRiconfigurazioni(ServiceStatus status) {
        for (MisuraMno misura : status.getRiconfigurazioniMno()) {
            Pod pod = misura.getPod();
            String azienda = pod.getAzienda();
            StatusTransaction transaction = new StatusTransaction(azienda, status, this.configuration);
            Mno mno = misura.getMno();
            String codicePod = pod.getCodice();
            try {
                this.riconfigura(pod, mno, transaction);
                transaction.commit(codicePod);
                MnoResult result = new MnoResult(mno, ErroriElaborazione.OK, "");
                status.addPnoElaborato(result);
                String flusso = mno.getCodiceFlusso();
                status.count(azienda, flusso, 1);
            }
            catch (BasicKeyException exc) {
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message("export.stdlet.strategy", message);
                sentence.setCss("alert-danger");
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
                MnoResult result = new MnoResult(mno, errore, descrizione);
                status.addPnoSospeso(result);
            }
            catch (RuntimeException exc) {
                String descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, "export.stdlet.strategy", this.talkManager, status);
                MnoResult result = new MnoResult(mno, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
                status.addPnoEscluso(result);
            }
        }
    }

    private void print(ServiceStatus status) throws FileNotFoundException {
        String specPiv = "-" + this.pivChecker.getId();
        LetstdPrintMapWriter printMapWriter = new LetstdPrintMapWriter(this.anno, this.mese, this.configuration);
        this.printDispatcher(printMapWriter, status);
        this.printResellerOrarie(printMapWriter, specPiv, status);
        this.printResellerNonorarie(printMapWriter, specPiv, status);
    }

    private void printDispatcher(LetstdPrintMapWriter printMapWriter, ServiceStatus status) throws FileNotFoundException {
        String idEsecuzione = status.getIdEsecuzione();
        Map<TipoLetStd, MapWriter> mapWriterMap = status.getMisureDispatcherWriter();
        for (Map.Entry<TipoLetStd, MapWriter> entry : mapWriterMap.entrySet()) {
            TipoLetStd tipo = entry.getKey();
            MapWriter mapWriter = entry.getValue();
            printMapWriter.printDispatcher(idEsecuzione, mapWriter, "", tipo.name().toLowerCase(), this.timestamp);
        }
    }

    private void printResellerOrarie(LetstdPrintMapWriter printMapWriter, String specPiv, ServiceStatus status) throws FileNotFoundException {
        String idEsecuzione = status.getIdEsecuzione();
        Map<String, Map<TipoLetStd, MapWriter>> mapWritersMap = status.getMisureOrarieWriter();
        String spec = "orari" + specPiv + "-";
        printMapWriter.printReseller(idEsecuzione, mapWritersMap, spec, "", this.timestamp);
    }

    private void printResellerNonorarie(LetstdPrintMapWriter printMapWriter, String specPiv, ServiceStatus status) throws FileNotFoundException {
        String idEsecuzione = status.getIdEsecuzione();
        Map<String, Map<TipoLetStd, MapWriter>> mapWriterMap = status.getMisureNonorarieWriter();
        printMapWriter.printReseller(idEsecuzione, mapWriterMap, "nonorari" + specPiv + "-", "", this.timestamp);
    }

    private void write(ServiceStatus status) throws CalendarNotFoundException {
        MappaMisureAzienda pnos = status.getPnos();
        for (MisureAzienda misureAzienda : pnos) {
            this.write(misureAzienda, status);
        }
    }

    private void write(MisureAzienda misureAzienda, ServiceStatus status) throws CalendarNotFoundException {
        for (MnoPod mnoPod : misureAzienda.getMisure()) {
            try {
                this.pivChecker.write(mnoPod, status, this);
            }
            catch (DuplicatePivException exc) {
                this.handleBasicKeyException(mnoPod, exc, status);
            }
        }
    }

    public void write(MnoPod mnoPod, ServiceStatus status) throws CalendarNotFoundException {
        String codicePod = mnoPod.getKey();
        String className = this.getClass().getSimpleName();
        PrebillingContext.setContext(className, "pod: " + codicePod);
        Collection<Mno> misurePdo2GR = mnoPod.getMisurePdo2GR();
        Collection<Mno> misurePeriodo = mnoPod.getMisurePno();
        Pod pod = mnoPod.getPod();
        String azienda = pod.getAzienda();
        ListMap<String, PraticaVolo> pivMap = status.getPiv();
        List pivList = (List)pivMap.get(codicePod);
        Date endDate = CalendarTools.getNextMese(this.anno, this.mese);
        if (ExportLetturePeriodoStrategy.checkPivVoltura(pivList, endDate)) {
            Map<String, String> suspendedPod = status.getSuspendedPod();
            String descrErrore = suspendedPod.get(codicePod);
            if (descrErrore == null) {
                try {
                    StatusTransaction transaction = new StatusTransaction(azienda, status, this.configuration);
                    CheckVolturaPdo2GHandler checkVolturaPdo2GHandler = new CheckVolturaPdo2GHandler(transaction);
                    this.checkVolture(misurePdo2GR, pivList, checkVolturaPdo2GHandler);
                    CheckVolturaPnoHandler checkVolturaPnoHandler = new CheckVolturaPnoHandler(transaction);
                    this.checkVolture(misurePeriodo, pivList, checkVolturaPnoHandler);
                    this.write(mnoPod, pivList, transaction, status);
                    transaction.handleDeferredStatiPod();
                    transaction.commit(codicePod);
                }
                catch (BasicKeyException exc) {
                    this.handleBasicKeyException(mnoPod, exc, status);
                }
                catch (MisuraException exc) {
                    PrebillingError errore = exc.getErrore();
                    String message = errore.getMessage();
                    Message sentence = new Message("export.stdlet.strategy", message);
                    DateFormat dataFormat = StrategyHelper.getDataFormat();
                    sentence.addParam(exc.getKey());
                    sentence.addParam(dataFormat.format(exc.getData()));
                    sentence.addParam(exc.getFlusso());
                    this.talkManager.addSentence(sentence);
                    String descrizione = this.talkManager.getMessage(sentence);
                    status.addMnoSospesi(misurePeriodo, errore, descrizione, endDate);
                    status.addPdo2GRSospesi(misurePdo2GR, errore, descrizione, endDate);
                }
                catch (SmisException exc) {
                    ErroriElaborazione errore = ErroriElaborazione.SMIS_NONAPPAIATO;
                    String message = errore.getMessage();
                    Message sentence = new Message("export.stdlet.strategy", message);
                    DateFormat dataFormat = StrategyHelper.getDataFormat();
                    sentence.addParam(exc.getCodicePod());
                    sentence.addParam(dataFormat.format(exc.getDataRilevazione()));
                    this.talkManager.addSentence(sentence);
                    String descrizione = this.talkManager.getMessage(sentence);
                    status.addMnoSospesi(misurePeriodo, errore, descrizione, endDate);
                    status.addPdo2GRSospesi(misurePdo2GR, errore, descrizione, endDate);
                }
                catch (CalendarException exc) {
                    Date start = exc.getStart();
                    String codiceOfferta = pod.getCodiceOfferta(start);
                    String calendarId = TariffeHelper.getCalendarId(codiceOfferta, status);
                    ErroriElaborazione errore = ErroriElaborazione.INCOMPATIBLE_CALENDAR;
                    String message = errore.getMessage();
                    Message sentence = new Message("export.stdlet.strategy", message);
                    DateFormat dataFormat = StrategyHelper.getDataFormat();
                    sentence.addParam(dataFormat.format(start));
                    sentence.addParam(dataFormat.format(exc.getEnd()));
                    sentence.addParam(codicePod);
                    sentence.addParam(calendarId);
                    this.talkManager.addSentence(sentence);
                    String descrizione = this.talkManager.getMessage(sentence);
                    status.addMnoSospesi(misurePeriodo, errore, descrizione, endDate);
                    status.addPdo2GRSospesi(misurePdo2GR, errore, descrizione, endDate);
                }
                catch (RuntimeException exc) {
                    String descrizione = StrategyHelper.handleRuntimeException(exc, codicePod, "export.stdlet.strategy", this.talkManager, status);
                    status.addPnoEsclusi(misurePeriodo, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
                    status.addPdo2GREsclusi(misurePdo2GR, ErroriElaborazione.EXCLUDING_ERROR, descrizione);
                }
            } else {
                status.addMnoSospesi(misurePeriodo, ErroriElaborazione.EXCLUDING_ERROR, descrErrore, endDate);
                status.addPdo2GRSospesi(misurePdo2GR, ErroriElaborazione.EXCLUDING_ERROR, descrErrore, endDate);
            }
        } else {
            String descrErrore = this.handleVolturaNonGestita(codicePod);
            status.addMnoSospesi(misurePeriodo, ErroriElaborazione.BLOCKING_VOLTURA, descrErrore, endDate);
            status.addPdo2GRSospesi(misurePdo2GR, ErroriElaborazione.BLOCKING_VOLTURA, descrErrore, endDate);
        }
    }

    private static boolean checkPivVoltura(List<PraticaVolo> pivList, Date endDate) {
        boolean ok = true;
        if (pivList != null) {
            for (PraticaVolo piv : pivList) {
                SpecificaTecnica specificaTecnica;
                Date dataVoltura;
                TipoPrestazione tipoPrestazione = piv.getTipoPrestazione();
                if (!TIPI_VOLTURA.contains((Object)tipoPrestazione) || !(dataVoltura = (specificaTecnica = piv.getSpecificaTecnica()).getData()).before(endDate)) continue;
                ok = false;
            }
        }
        return ok;
    }

    private void handleBasicKeyException(MnoPod mnoPod, BasicKeyException exc, ServiceStatus status) {
        Collection<Mno> misurePdo2GR = mnoPod.getMisurePdo2GR();
        Collection<Mno> misurePeriodo = mnoPod.getMisurePno();
        String message = exc.getMessage();
        Message sentence = new Message("export.stdlet.strategy", message);
        List<String> params = exc.getParams();
        sentence.setParams(params);
        Pod pod = mnoPod.getPod();
        String codicePod = pod.getCodice();
        sentence.addParam(codicePod);
        this.talkManager.addSentence(sentence);
        String descrizione = this.talkManager.getMessage(sentence);
        ErroriElaborazione errore = StrategyHelper.getErroreElaborazione(exc);
        Date endDate = CalendarTools.getNextMese(this.anno, this.mese);
        status.addMnoSospesi(misurePeriodo, errore, descrizione, endDate);
        status.addPdo2GRSospesi(misurePdo2GR, errore, descrizione, endDate);
    }

    private String handleVolturaNonGestita(String codicePod) {
        Message sentence = new Message("export.stdlet.strategy", "blocking.voltura");
        sentence.addParam(codicePod);
        this.talkManager.addSentence(sentence);
        return this.talkManager.getMessage(sentence);
    }

    private void checkVolture(Collection<Mno> misure, List<PraticaVolo> pivList, CheckVolturaHandler checkVolturaHandler) {
        Iterator<Mno> iterator = misure.iterator();
        while (iterator.hasNext()) {
            Mno mno = iterator.next();
            String codiceFlusso = mno.getCodiceFlusso();
            String raccolta = mno.getRaccoltaEstesa();
            if (!codiceFlusso.endsWith("2G") || !raccolta.equals("V") || ExportLetturePeriodoStrategy.checkVT4(mno, pivList)) continue;
            ErroriElaborazione errore = ErroriElaborazione.VOLTURA_ESCLUSA_NO_PIV;
            String message = errore.getMessage();
            Message sentence = new Message("", message);
            String codicePod = mno.getCodicePod();
            sentence.addParam(codicePod);
            Date dataMisura = mno.getDataMisura();
            sentence.addParam(this.dateFormat.format(dataMisura));
            String descrizione = this.talkManager.getMessage(sentence);
            MnoResult result = new MnoResult(mno, errore, descrizione);
            checkVolturaHandler.addVolturaEsclusa(result);
            iterator.remove();
        }
    }

    private static boolean checkVT4(Mno mno, List<PraticaVolo> pivList) {
        boolean vt4 = false;
        Date dataPrestazione = mno.getDataPrestazione();
        if (pivList != null) {
            Iterator<PraticaVolo> iterator = pivList.iterator();
            while (!vt4 && iterator.hasNext()) {
                PraticaVolo current = iterator.next();
                String prestazione = current.getCodicePrestazione();
                SpecificaTecnica specificaTecnica = current.getSpecificaTecnica();
                Date dataPratica = specificaTecnica.getData();
                boolean bl = vt4 = prestazione.equals("VT4") && dataPratica.equals(dataPrestazione);
            }
        }
        return vt4;
    }

    private void write(MnoPod mnoPod, List<PraticaVolo> pivList, StatusTransaction transaction, ServiceStatus status) throws DataNotFoundException, StatoPodCheckException, PraticaAnnullataException, MisuraNotAlignedException, InvalidFasciaValue, CalendarNotFoundException, CalendarException, IncoherentTrattamentoException, MisuraException, SmisException {
        Collection<ExtMno> smis = mnoPod.getSmis();
        Date dataMisuraPrestazione = ExportLetturePeriodoStrategy.getDataMisuraPrestazione(pivList, smis);
        Collection<Mno> misurePeriodo = mnoPod.getMisurePno();
        Collection<Mno> misurePdo2gr = mnoPod.getMisurePdo2GR();
        List<Mno> reversed = ArrayHelper.reverse(misurePdo2gr);
        List<Mno> misure = MisureHelper.merge(misurePeriodo, reversed);
        this.write(mnoPod, misure, smis, dataMisuraPrestazione, transaction, status);
    }

    private static Date getDataMisuraPrestazione(List<PraticaVolo> pivList, Collection<ExtMno> smis) {
        Date dataMisuraPrestazione = CalendarTools.getEndOfTime();
        if (pivList != null && !pivList.isEmpty()) {
            SpecificaTecnica specificaTecnica = pivList.get(0).getSpecificaTecnica();
            dataMisuraPrestazione = specificaTecnica.getData();
        }
        if (!smis.isEmpty()) {
            ExtMno first = smis.iterator().next();
            Mno mno = first.getMno();
            Date smisDate = mno.getDataMisura();
            dataMisuraPrestazione = CalendarTools.min(dataMisuraPrestazione, smisDate);
        }
        return dataMisuraPrestazione;
    }

    private void write(MnoPod mnoPod, Collection<Mno> misurePeriodo, Collection<ExtMno> smisCollection, Date dataMisuraPrestazione, StatusTransaction transaction, ServiceStatus status) throws DataNotFoundException, StatoPodCheckException, PraticaAnnullataException, MisuraNotAlignedException, InvalidFasciaValue, CalendarNotFoundException, CalendarException, IncoherentTrattamentoException, MisuraException, SmisException {
        if (!misurePeriodo.isEmpty() || !smisCollection.isEmpty()) {
            Date inizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
            Date inizioMeseSuccessivo = CalendarTools.getNextMese(this.anno, this.mese);
            Pod pod = mnoPod.getPod();
            String azienda = pod.getAzienda();
            String cdcomist = pod.getCdcomist();
            String codiceOfferta = pod.getCodiceOfferta(inizioMese);
            Mno mnoRiferimento = this.findMnoRiferimento(pod, inizioMese, misurePeriodo);
            Mno tappoMisura = TariffeHelper.buildMnoTappo();
            TappoIterator<Mno> mpIterator = ExportLetturePeriodoStrategy.getMisureTappoIterator(misurePeriodo, tappoMisura);
            Mno nextMno = mpIterator.next();
            while (true) {
                boolean checkOutDate;
                String codiceFlusso = nextMno.getCodiceFlusso();
                Date dataMisura = nextMno.getDataMisura();
                MisuraHandler handler = this.buildMisuraHandler(codiceFlusso);
                if (StrategyHelper.PIV_CDUNIPRE_LIST.contains(codiceFlusso) && !this.pivChecker.isPiv()) {
                    int errore = ErroriElaborazione.PIV_NOTFOUND.ordinal();
                    String codicePod = nextMno.getCodicePod();
                    throw new DataNotFoundException("piv.notfound", codicePod, errore);
                }
                Date dataMisuraPrec = mnoRiferimento.getDataMisura();
                Date dataFirst = CalendarTools.nextDay(dataMisuraPrec);
                Date expectedDate = CalendarTools.getEndOfMonth(dataFirst);
                Mno effMno = ExportLetturePeriodoStrategy.findEffMno(nextMno, smisCollection, inizioMeseSuccessivo);
                nextMno.setCdaziend(azienda);
                if (effMno != null) {
                    effMno.setCdaziend(azienda);
                    if (codiceFlusso.startsWith("RNO")) {
                        handler.addElaborato(pod, nextMno, transaction);
                    } else {
                        ErroriElaborazione errore = ErroriElaborazione.BLOCKING_SMIS;
                        String message = errore.getMessage();
                        Message sentence = new Message("export.stdlet.strategy", message);
                        String codicePod = pod.getCodice();
                        sentence.addParam(codicePod);
                        this.talkManager.addSentence(sentence);
                        String descrizione = this.talkManager.getMessage(sentence);
                        MnoResult result = new MnoResult(nextMno, errore, descrizione);
                        handler.addObsoleto(result, transaction);
                    }
                }
                if (SwitchoutHelper.checkSwitchOut(pod, nextMno, checkOutDate = this.pivChecker.isCheckOutDate())) {
                    effMno = effMno == null ? nextMno : effMno;
                    this.addSwitchout(mnoPod, effMno, inizioMeseSuccessivo, handler, transaction);
                } else if (effMno == null) {
                    MnoResult result;
                    String descrizione;
                    String codicePod;
                    Message sentence;
                    TipoLetStd tipo = dataMisuraPrestazione.before(dataMisura) ? TipoLetStd.PIV : TipoLetStd.NOPIV;
                    try {
                        while (expectedDate.before(dataMisura) && expectedDate.before(inizioMeseSuccessivo)) {
                            Pair<Mno, Mno> smis = ExportLetturePeriodoStrategy.findSmis(dataMisuraPrec, dataMisura, smisCollection);
                            Mno smontaggio = smis.getFirst();
                            if (smontaggio == null) {
                                if (!dataMisura.before(inizioMeseSuccessivo)) break;
                                Mno profilata = this.profilaMisura(mnoRiferimento, nextMno, cdcomist, codiceOfferta, expectedDate, status);
                                MisuraMno misuraMno = new MisuraMno(pod, profilata);
                                transaction.addMisuraNonorariaPeriodo(misuraMno, TipoLetStd.NOPIV);
                                transaction.count("letture_calcolate");
                                expectedDate = CalendarTools.getEndOfMonth(CalendarTools.nextDay(expectedDate));
                                mnoRiferimento = profilata;
                            } else {
                                Date dataSmontaggio = smontaggio.getDataMisura();
                                if (!dataSmontaggio.before(inizioMeseSuccessivo)) break;
                                Mno montaggio = smis.getSecond();
                                if (!dataSmontaggio.after(expectedDate)) {
                                    mnoRiferimento = montaggio;
                                    expectedDate = CalendarTools.getEndOfMonth(CalendarTools.nextDay(expectedDate));
                                } else {
                                    Mno profilata = this.profilaMisura(mnoRiferimento, smontaggio, cdcomist, codiceOfferta, expectedDate, status);
                                    MisuraMno misuraMno = new MisuraMno(pod, profilata);
                                    transaction.addMisuraNonorariaPeriodo(misuraMno, TipoLetStd.NOPIV);
                                    transaction.count("letture_calcolate");
                                    expectedDate = CalendarTools.getEndOfMonth(CalendarTools.nextDay(expectedDate));
                                    mnoRiferimento = expectedDate.after(dataSmontaggio) ? montaggio : profilata;
                                }
                            }
                            dataMisuraPrec = mnoRiferimento.getDataMisura();
                        }
                        if (!dataMisura.before(inizioMeseSuccessivo)) break;
                        this.write(pod, nextMno, tipo, transaction);
                        String flusso = StatusTransaction.handleElaborato(pod, azienda, nextMno, handler, this.doubleFormat, transaction);
                        transaction.count(flusso);
                    }
                    catch (MisuraObsoletaSmisException exc) {
                        sentence = new Message("export.stdlet.strategy", "blocking.smis");
                        codicePod = exc.getCodicePod();
                        sentence.addParam(codicePod);
                        sentence.addParam(this.dateFormat.format(exc.getDataMisura()));
                        this.talkManager.addSentence(sentence);
                        descrizione = this.talkManager.getMessage(sentence);
                        result = new MnoResult(nextMno, ErroriElaborazione.BLOCKING_SMIS, descrizione);
                        transaction.addPnoObsoleto(result);
                    }
                    catch (PnoObsoletoException exc) {
                        sentence = new Message("export.stdlet.strategy", "obsoleto");
                        codicePod = exc.getCodicePod();
                        sentence.addParam(codicePod);
                        sentence.addParam(this.dateFormat.format(exc.getDataMisura()));
                        this.talkManager.addSentence(sentence);
                        descrizione = this.talkManager.getMessage(sentence);
                        result = new MnoResult(nextMno, ErroriElaborazione.OBSOLETO, descrizione);
                        transaction.addPnoObsoleto(result);
                    }
                }
                if (dataMisura.after(dataMisuraPrec) || !SMRT.contains(codiceFlusso.substring(0, 2))) {
                    mnoRiferimento = nextMno;
                }
                nextMno = mpIterator.next();
            }
        }
    }

    private MisuraHandler buildMisuraHandler(String codiceFlusso) {
        return codiceFlusso.startsWith("PDO") || codiceFlusso.startsWith("RFO") ? new Pdo2GRMisuraHandler(this.configuration, this.talkManager) : new PnoMisuraHandler();
    }

    private static Pair<Mno, Mno> findSmis(Date dataPrev, Date dataMisura, Collection<ExtMno> smisCollection) throws SmisException {
        Mno smontaggio = null;
        Mno montaggio = null;
        Iterator<ExtMno> iterator = smisCollection.iterator();
        while (smontaggio == null && iterator.hasNext()) {
            ExtMno smis = iterator.next();
            Mno smisMno = smis.getMno();
            Date dataSmis = smisMno.getDataMisura();
            boolean isMontaggio = smisMno.isSmisMontaggio();
            if (isMontaggio || dataSmis.before(dataPrev) || !dataSmis.before(dataMisura)) continue;
            smontaggio = smisMno;
            if (iterator.hasNext()) {
                montaggio = iterator.next().getMno();
                if (montaggio.isSmisMontaggio()) continue;
                String codicePod = smisMno.getCodicePod();
                throw new SmisException(codicePod, dataSmis);
            }
            String codicePod = smisMno.getCodicePod();
            throw new SmisException(codicePod, dataSmis);
        }
        return new Pair<Object, Object>(smontaggio, montaggio);
    }

    private static TappoIterator<Mno> getMisureTappoIterator(Collection<Mno> misurePeriodo, Mno tappoMisura) {
        Iterator<Mno> iterator = misurePeriodo.iterator();
        return new TappoIterator<Mno>(iterator, tappoMisura);
    }

    private Mno findMnoRiferimento(Pod pod, Date inizioMese, Collection<Mno> misurePeriodo) {
        Date dataStart = ExportLetturePeriodoStrategy.getDataStart(inizioMese, misurePeriodo);
        Mno mnoRiferimento = ExportLetturePeriodoStrategy.buildMnoFromPod(pod);
        List<Mno> pnoElaborati = this.misureDao.getPnoElaborati(pod);
        mnoRiferimento = ExportLetturePeriodoStrategy.updateMnoRiferimento(dataStart, mnoRiferimento, pnoElaborati);
        List<Mno> pdo2grElaborati = this.misureDao.getPdo2GRElaborati(pod);
        mnoRiferimento = ExportLetturePeriodoStrategy.updateMnoRiferimento(dataStart, mnoRiferimento, pdo2grElaborati);
        return mnoRiferimento;
    }

    private static Date getDataStart(Date inizioMese, Collection<Mno> misurePeriodo) {
        Date dataStart;
        Iterator<Mno> iterator = misurePeriodo.iterator();
        if (iterator.hasNext()) {
            Mno first = iterator.next();
            Date dataFirst = first.getDataMisura();
            dataStart = CalendarTools.min(dataFirst, inizioMese);
        } else {
            dataStart = inizioMese;
        }
        return dataStart;
    }

    private static Mno updateMnoRiferimento(Date dataStart, Mno actual, List<? extends Mno> misureElaborate) {
        Mno updated = actual;
        Date dataPrecedente = actual.getDataMisura();
        for (Mno mno : misureElaborate) {
            Date dataMisura = mno.getDataMisura();
            if (!dataMisura.before(dataStart) || !dataMisura.after(dataPrecedente)) continue;
            updated = mno;
            dataPrecedente = dataMisura;
        }
        return updated;
    }

    private static Mno buildMnoFromPod(Pod pod) {
        String codicePod = pod.getCodice();
        Date dataMax = pod.getDataMax();
        Misura misura = new Misura(dataMax, false, 3, "giada");
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            double value = pod.getLastAttiva()[fascia.ordinal()];
            misura.setAttiva(fascia, value, 0.0);
            ++n3;
        }
        return new Mno(null, "giada", codicePod, misura, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, false, false, null);
    }

    private Mno profilaMisura(Mno mnoPrecedente, Mno mno, String cdcomist, String codiceOfferta, Date dataCalcolata, ServiceStatus status) throws DataNotFoundException, CalendarNotFoundException, CalendarException, IncoherentTrattamentoException, MisuraException {
        int numCifre;
        Date dataMisuraIniziale = mnoPrecedente.getDataMisura();
        Date dataMisuraFinale = mno.getDataMisura();
        String pivaDistributore = mno.getPivaDistributore();
        double[] profilo = TariffeHelper.getProfilo(pivaDistributore, dataMisuraIniziale, dataMisuraFinale, cdcomist, status);
        String codicePod = mno.getCodicePod();
        FasciaOraria[] fasce = TariffeHelper.getFasce(codicePod, codiceOfferta, dataMisuraIniziale, dataMisuraFinale, status);
        try {
            numCifre = Integer.parseInt(mno.getCifreAtt());
        }
        catch (Exception exc) {
            numCifre = this.configuration.getDefaultCifreContatore();
        }
        double[] prevAttiva = mnoPrecedente.getAttiva();
        double[] finAttiva = mno.getAttiva();
        boolean monorario = ExportLetturePeriodoStrategy.checkMonorario(mnoPrecedente, mno);
        String codiceFlusso = mno.getCodiceFlusso();
        double[] attiva = ExportLetturePeriodoStrategy.profila(codicePod, dataCalcolata, dataMisuraIniziale, dataMisuraFinale, profilo, fasce, prevAttiva, finAttiva, codiceFlusso, numCifre, monorario);
        double[] prevReattiva = mnoPrecedente.getReattiva();
        double[] finReattiva = mno.getReattiva();
        double[] reattiva = ExportLetturePeriodoStrategy.profila(codicePod, dataCalcolata, dataMisuraIniziale, dataMisuraFinale, profilo, fasce, prevReattiva, finReattiva, codiceFlusso, numCifre, monorario);
        double[] potenza = mno.getPotenza();
        Misura misura = new Misura(dataCalcolata, false, 3, "int");
        FasciaOraria[] fasciaOrariaArray = FasciaOraria.values();
        int n2 = fasciaOrariaArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FasciaOraria fascia = fasciaOrariaArray[n3];
            int ordinal = fascia.ordinal();
            misura.setAttiva(fascia, prevAttiva[ordinal] + attiva[ordinal], 0.0);
            misura.setReattiva(fascia, prevReattiva[ordinal] + reattiva[ordinal], 0.0);
            misura.setPotenza(fascia, potenza[ordinal], 0.0);
            ++n3;
        }
        Map<String, Map<String, String>> datiPod = mno.getDatiPod();
        boolean pdo2gr = mno.isPdo2GR();
        return new Mno(null, "int", codicePod, misura, null, pivaDistributore, null, null, null, null, null, datiPod, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, false, pdo2gr, null);
    }

    private static boolean checkMonorario(Mno mnoPrecedente, Mno mno) throws IncoherentTrattamentoException {
        boolean monoPrec;
        boolean mono = mno.getTrattamento().isMono();
        Trattamento trattamentoPrecedente = mnoPrecedente.getTrattamento(null);
        if (trattamentoPrecedente != null && mono != (monoPrec = trattamentoPrecedente.isMono())) {
            String codicePod = mno.getCodicePod();
            Date dataMisuraPrec = mnoPrecedente.getDataMisura();
            Date dataMisura = mno.getDataMisura();
            throw new IncoherentTrattamentoException(codicePod, dataMisuraPrec, dataMisura);
        }
        return mono;
    }

    private static double[] profila(String codicePod, Date data, Date dataMisuraIniziale, Date dataMisuraFinale, double[] profilo, FasciaOraria[] fasce, double[] misuraIniziale, double[] misuraFinale, String flusso, int numCifre, boolean monorario) throws CalendarException, MisuraException {
        double[] consumoFasce = TariffeHelper.getConsumoFasce(misuraIniziale, misuraFinale, numCifre, codicePod, dataMisuraFinale, flusso, false);
        List<Double> consumi = TariffeHelper.calcolaConsumi(consumoFasce, dataMisuraIniziale, dataMisuraFinale, dataMisuraIniziale, data, profilo, fasce, monorario);
        double[] calcolata = new double[FasciaOraria.values().length];
        int index = 0;
        for (Double consumo : consumi) {
            FasciaOraria fascia = monorario ? FasciaOraria.F1 : fasce[index];
            int n2 = fascia.ordinal();
            calcolata[n2] = calcolata[n2] + consumo;
            ++index;
        }
        return calcolata;
    }

    private void addSwitchout(MnoPod mnoPod, Mno mno, Date dataMax, MisuraHandler handler, StatusTransaction transaction) throws DataNotFoundException {
        Misura misura = mno.getMisura();
        Date dataMisura = misura.getDate();
        if (dataMisura.before(dataMax)) {
            Pod pod;
            MisuraMno misuraPod;
            Mno effMno = this.findEffVno(mno, handler, transaction);
            String codiceFlusso = effMno.getCodiceFlusso();
            TipoFlusso tipoFlusso = TipoFlusso.valueOf(codiceFlusso);
            if (tipoFlusso.checkRettificaSwitchout(misuraPod = new MisuraMno(pod = mnoPod.getPod(), effMno), this.misureDao)) {
                transaction.addRettificaSwitchOutDispatcher(misuraPod);
                MnoResult result = new MnoResult(effMno, ErroriElaborazione.OK, "");
                transaction.addPnoElaborato(result);
                transaction.addLettura(misuraPod);
            } else {
                mnoPod.addSwitchout(effMno);
            }
        }
    }

    private Mno findEffVno(Mno mno, MisuraHandler handler, StatusTransaction transaction) {
        Mno effMno;
        try {
            String codicePod = mno.getCodicePod();
            Date dataPrestazione = mno.getDataPrestazione();
            effMno = this.misureDao.getVno(codicePod, dataPrestazione);
            if (effMno.getId() != mno.getId()) {
                Message sentence = new Message("export.stdlet.strategy", "vno.blocking");
                sentence.addParam(codicePod);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroriElaborazione errore = ErroriElaborazione.BLOCKING_VNO;
                MnoResult result = new MnoResult(mno, errore, descrizione);
                handler.addObsoleto(result, transaction);
            }
        }
        catch (DataNotFoundException exc) {
            effMno = mno;
        }
        return effMno;
    }

    private static Mno findEffMno(Mno mno, Collection<ExtMno> smisPod, Date endDate) {
        Mno value = null;
        Date dataMisura = mno.getDataMisura();
        if (dataMisura.before(endDate)) {
            for (ExtMno smis : smisPod) {
                Date dataSmontaggio;
                Mno mnoSmis = smis.getMno();
                String raccolta = mnoSmis.getRaccolta();
                if (!"S".equalsIgnoreCase(raccolta) || !dataMisura.equals(dataSmontaggio = mnoSmis.getDataMisura())) continue;
                value = mnoSmis;
                String codiceFlusso = mno.getCodiceFlusso();
                if (!codiceFlusso.startsWith("RNO")) continue;
                value.setValues(mno);
            }
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void write(Pod pod, Mno mno, TipoLetStd tipo, StatusTransaction transaction) throws MisuraNotAlignedException, DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException, PnoObsoletoException, MisuraObsoletaSmisException {
        if (ExportLetturePeriodoStrategy.checkRiconfigurazioneRno(pod, mno)) {
            this.riconfigura(pod, mno, transaction);
            return;
        }
        boolean smis = ExportLetturePeriodoStrategy.isRettificaSmis(pod, mno);
        MisuraMno misuraMno = new MisuraMno(pod, mno, smis);
        if (StrategyHelper.checkAllineamento(pod, mno)) {
            Date dataInizioUtenza;
            ExportLetturePeriodoStrategy.checkLetturaSmis(pod, mno);
            ExportLetturePeriodoStrategy.checkMissingSmis(pod, mno);
            if (!StrategyHelper.checkK(pod, mno)) {
                String codicePod = pod.getCodice();
                throw new MisuraNotAlignedException(codicePod);
            }
            Date dataMisura = mno.getDataMisura();
            Date expectedStart = CalendarTools.nextDay(dataMisura);
            if (expectedStart.equals(dataInizioUtenza = pod.getDataInizio(expectedStart))) {
                transaction.addRettificaMno(misuraMno);
                return;
            }
            transaction.addMisuraNonorariaPeriodo(misuraMno, tipo);
            return;
        }
        Misura misura = mno.getMisura();
        if (misura.isStimata()) {
            Warning sentence = new Warning("export.stdlet.strategy", "notaligned.pod");
            String codicePod = pod.getCodice();
            sentence.addParam(codicePod);
            this.talkManager.addSentence(sentence);
            transaction.addMisuraNonorariaPeriodo(misuraMno, tipo);
            return;
        }
        transaction.addMisuraDisallineata(misuraMno);
    }

    private static void checkLetturaSmis(Pod pod, Mno mno) throws MisuraObsoletaSmisException {
        String flusso = mno.getCodiceFlusso();
        if (FLUSSI.contains(flusso)) {
            Date dataMisura = mno.getDataMisura();
            boolean flazzcon = pod.isAzzeramento(dataMisura);
            Date dataMax = pod.getDataMax();
            Date dataNext = CalendarTools.nextDay(dataMisura);
            Date dataInst = pod.getDataInst(dataNext);
            if (!flazzcon && dataMax.equals(dataMisura) && dataInst.equals(dataNext)) {
                String codicePod = pod.getCodice();
                throw new MisuraObsoletaSmisException(codicePod, dataMisura);
            }
        }
    }

    private static boolean isRettificaSmis(Pod pod, Mno mno) {
        Date dataMisura = mno.getDataMisura();
        Date dataNext = CalendarTools.nextDay(dataMisura);
        Date dataInst = pod.getDataInst(dataNext);
        Date dataInizio = pod.getDataInizio(dataNext);
        return !dataNext.equals(dataInizio) && dataNext.equals(dataInst);
    }

    private static void checkMissingSmis(Pod pod, Mno mno) throws PnoObsoletoException {
        Date dataMisura = mno.getDataMisura();
        boolean flazzcon = pod.isAzzeramento(dataMisura);
        boolean podNuovo = pod.isPodNuovo(dataMisura);
        Date dataMax = pod.getDataMax();
        Date dataPrev = CalendarTools.previousDay(dataMisura);
        Date dataInst = pod.getDataInst(dataMisura);
        if (!flazzcon && podNuovo && dataMax.equals(dataPrev) && dataInst.equals(dataMisura)) {
            String codicePod = pod.getCodice();
            throw new PnoObsoletoException(codicePod, dataMisura);
        }
    }

    private void riconfigura(Pod pod, Mno mno, StatusTransaction transaction) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        String codicePrestazione;
        String azienda = pod.getAzienda();
        SafeMap<String, Reseller> resellers = transaction.getResellers();
        Reseller reseller = (Reseller)resellers.get(azienda);
        if (reseller.isHandleStato()) {
            String codicePod = pod.getCodice();
            Date dataMisura = mno.getDataMisura();
            Date dataAttivazione = CalendarTools.nextDay(dataMisura);
            StatoPod refStatoPod = this.misureDao.getStatoPod(SERVIZIO, codicePod, dataAttivazione);
            codicePrestazione = refStatoPod.getCdunipre();
            String codicePratica = refStatoPod.getCpGestore();
            RnoStatoPodHandler rnoStatoPodHandler = new RnoStatoPodHandler(SERVIZIO, this.misureDao, refStatoPod);
            MisuraMno misuraPod = new MisuraMno(pod, mno);
            rnoStatoPodHandler.handleStato(misuraPod, codicePrestazione, codicePratica, transaction);
        } else {
            codicePrestazione = "";
        }
        MisuraGiada mnoPrev = new MisuraGiada(pod, mno);
        String codiceFlusso = mno.getCodiceFlusso();
        ExtendedLT misura = new ExtendedLT(mno, mnoPrev, pod, pod, false, codicePrestazione, codiceFlusso, "G");
        transaction.addMisuraTecnica(misura);
    }

    private static boolean checkRiconfigurazioneRno(Pod pod, Mno mno) throws DataNotFoundException {
        boolean riconfigurazione = false;
        String codiceFlusso = mno.getCodiceFlusso();
        if (codiceFlusso.startsWith("RNO") || codiceFlusso.startsWith("RFO")) {
            Date dataMisura = mno.getDataMisura();
            Date dataNext = CalendarTools.nextDay(dataMisura);
            Date dataInstallazione = pod.getDataInst(dataNext);
            if (dataInstallazione == null) {
                String codicePod = pod.getCodice();
                int errore = ErroriElaborazione.POD_NOTFOUND.ordinal();
                throw new DataNotFoundException("pod.notfound", codicePod, errore);
            }
            if (dataNext.equals(dataInstallazione)) {
                riconfigurazione = pod.isPodNuovo(dataMisura) && (ExportLetturePeriodoStrategy.checkAttiva(pod, mno, dataMisura) || ExportLetturePeriodoStrategy.checkReattiva(pod, mno, dataMisura) || ExportLetturePeriodoStrategy.checkPotenza(pod, mno, dataMisura));
            }
        }
        return riconfigurazione;
    }

    public static boolean checkPotenza(Pod pod, Mno mno, Date dataMisura) {
        boolean riconfigura = false;
        if (pod.isMisuraPotenza(dataMisura)) {
            riconfigura = pod.getKp(dataMisura) != mno.getKp().doubleValue();
        }
        return riconfigura;
    }

    public static boolean checkReattiva(Pod pod, Mno mno, Date dataMisura) {
        boolean riconfigura = false;
        if (pod.isMisuraReattiva(dataMisura)) {
            riconfigura = pod.getKr(dataMisura) != mno.getKr().doubleValue();
        }
        return riconfigura;
    }

    public static boolean checkAttiva(Pod pod, Mno mno, Date dataMisura) {
        boolean riconfigura = false;
        if (pod.isMisuraAttiva(dataMisura)) {
            riconfigura = pod.getKa(dataMisura) != mno.getKa().doubleValue();
        }
        return riconfigura;
    }
}

