/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.common.MisuraAccumulator;
import biz.elabor.prebilling.services.letture.MisureMese;
import java.util.Date;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;

public class ConsumiServiceHelper {
    private final String idCalendario;
    private final PrebillingConfiguration configuration;
    private final CalendarMap calendarMap;

    public ConsumiServiceHelper(String idCalendario, PrebillingDao prebillingDao, PrebillingConfiguration configuration) {
        this.idCalendario = idCalendario;
        this.configuration = configuration;
        this.calendarMap = new CalendarMap(prebillingDao);
    }

    public MisureMese getMisureMese(Pdo pdo, Date dataInizio, Date dataFine) throws CalendarNotFoundException {
        Date expectedDate;
        Date nextDate;
        Misura misura;
        Date misuraDate;
        MisureMese misureMese = new MisureMese();
        RilMese rilMese = pdo.getRilMese();
        MisuraAccumulator accumulator = new MisuraAccumulator(rilMese, this.calendarMap, this.configuration);
        if (!this.idCalendario.isEmpty()) {
            String codicePod = pdo.getCodicePod();
            accumulator.setOfferta(this.idCalendario, codicePod, this.idCalendario);
        }
        Date startDate = CalendarTools.previousDay(dataInizio);
        while ((misuraDate = (misura = accumulator.buildMisuraRaw(false, startDate)).getDate()).before(startDate)) {
        }
        startDate = accumulator.getExpectedDate();
        do {
            misura = accumulator.buildMisuraRaw(false, dataFine);
            Set<String> id = misura.getId();
            misuraDate = misura.getDate();
            if (misuraDate == null || id.isEmpty()) break;
            misureMese.add(misura, startDate, misuraDate);
            expectedDate = accumulator.getExpectedDate();
        } while (!(nextDate = CalendarTools.nextDay(misuraDate)).before(expectedDate) && misuraDate.before(dataFine));
        return misureMese;
    }
}

