/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.ConsumiHelper;
import biz.elabor.prebilling.services.letture.ConsumiService;
import biz.elabor.prebilling.services.letture.ConsumiServiceHelper;
import biz.elabor.prebilling.services.letture.MisureMese;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ConsumiPodService
implements ConsumiService {
    private final String codicePod;
    private final Date dataInizio;
    private final Date dataFine;
    private final String reseller;
    private final MisureDao misureDao;
    private final ConsumiServiceHelper helper;
    private final TalkManager talkManager;

    public ConsumiPodService(String codicePod, Date dataInizio, Date dataFine, String idCalendario, String reseller, PrebillingDao prebillingDao, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) {
        this.codicePod = codicePod;
        this.dataInizio = dataInizio;
        this.dataFine = dataFine;
        this.reseller = reseller;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.helper = new ConsumiServiceHelper(idCalendario, prebillingDao, configuration);
    }

    @Override
    public List<Misura> getMisure() throws CalendarNotFoundException, DataNotFoundException {
        ArrayList<Misura> misure = new ArrayList<Misura>();
        WorkingPeriod wp = new WorkingPeriod(this.dataInizio);
        WorkingPeriod endWP = new WorkingPeriod(this.dataFine);
        Date endDate = endWP.getLastDate();
        Date firstDate = null;
        Date lastDate = null;
        double kPeriodo = 0.0;
        while (wp.getStartDate().before(endDate)) {
            int anno = wp.getYear();
            Month mese = wp.getMonth();
            try {
                Pdo pdo = this.misureDao.getPdo(this.codicePod, anno, mese, this.reseller, StrategyHelper.STATI_ALL);
                MisureMese misureMese = this.helper.getMisureMese(pdo, this.dataInizio, this.dataFine);
                kPeriodo = ConsumiHelper.updateK(kPeriodo, misureMese.getKa());
                Date meseFirstDate = misureMese.getFirstDate();
                Date meseLastDate = misureMese.getLastDate();
                if (meseFirstDate != null) {
                    if (firstDate == null) {
                        firstDate = meseFirstDate;
                    } else {
                        Date nextDate = CalendarTools.nextDay(lastDate);
                        if (nextDate.before(meseFirstDate)) break;
                    }
                    misure.addAll(misureMese.getMisure());
                    lastDate = meseLastDate;
                    Date wpEndDate = wp.getLastDate();
                    if (lastDate.before(wpEndDate)) {
                        break;
                    }
                }
            }
            catch (DataNotFoundException dataNotFoundException) {
                // empty catch block
            }
            wp = wp.next();
        }
        if (firstDate == null) {
            throw new DataNotFoundException("pod.misurenotfound", this.codicePod);
        }
        Message sentence = new Message("consumi", "intervallo.misure");
        sentence.addParam(this.codicePod);
        DateFormat dateFormat = StrategyHelper.getDataFormat();
        sentence.addParam(dateFormat.format(firstDate));
        sentence.addParam(dateFormat.format(lastDate));
        sentence.addParam(ConsumiHelper.getKMessage(kPeriodo));
        this.talkManager.addSentence(sentence);
        return misure;
    }

    @Override
    public String getCodicePod() {
        return this.codicePod;
    }
}

