/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.giada.Fittizia;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PodMap;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.model.statomisure.PdoResult;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.consolidamento.SplitConsolidamentoStrategy;
import biz.elabor.prebilling.services.letture.ExclusionCondition;
import biz.elabor.prebilling.services.letture.LateProcessingPTH;
import biz.elabor.prebilling.services.volture.model.VolturaIV;
import biz.elabor.prebilling.web.letture.SpecificaPrestazione;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.arrays.Filter;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.MultipleRowException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.safe.SafeMap;

public class CheckLateProcessingStrategy
implements ServiceStrategy {
    private static final PraticaTardivaHandler PT_HANDLER = new LateProcessingPTH();
    private final Funzionalita funzionalita;
    private final Reseller reseller;
    private final int anno;
    private final Month mese;
    private final MisureDao misureDao;
    private final GiadaDao giadaDao;
    private final TalkManager talkManager;
    private final PrebillingConfiguration configuration;
    private final DateFormat dataFormat;
    private final Map<String, SpecificaPrestazione> prestazioni;
    private final String onlyPod;

    public CheckLateProcessingStrategy(Funzionalita funzionalita, Reseller reseller, int anno, Month mese, String onlyPod, Map<String, SpecificaPrestazione> prestazioni, PrebillingConfiguration configuration, MisureDao misureDao, GiadaDao giadaDao, TalkManager talkManager) {
        this.funzionalita = funzionalita;
        this.reseller = reseller;
        this.anno = anno;
        this.mese = mese;
        this.onlyPod = onlyPod;
        this.prestazioni = prestazioni;
        this.configuration = configuration;
        this.misureDao = misureDao;
        this.giadaDao = giadaDao;
        this.talkManager = talkManager;
        this.dataFormat = StrategyHelper.getDataFormat();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        this.handlePiv(status);
        this.handleFittizie(status);
        return true;
    }

    private void handleFittizie(ServiceStatus status) {
        List<Fittizia> fittizie = this.giadaDao.getFittizie(this.onlyPod);
        for (Fittizia fittizia : fittizie) {
            String codicePod = fittizia.getCodicePod();
            Date attesaSnm = fittizia.getAttesaSnm();
            if (attesaSnm == null) continue;
            Date dataPrestazione = CalendarTools.nextDay(attesaSnm);
            try {
                VolturaIV volturaIV = this.misureDao.getVolturaIV(codicePod, dataPrestazione);
                String azienda = volturaIV.getCdaziend();
                if (!this.reseller.match(azienda)) continue;
                this.checkLateProcessing(volturaIV, status);
            }
            catch (DataNotFoundException volturaIV) {
            }
            catch (MultipleRowException exc) {
                Message sentence = new Message("late.processing", "toomany.flussiinterni");
                sentence.addParam(codicePod);
                DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
                sentence.addParam(dateFormat.format(dataPrestazione));
                this.talkManager.addSentence(sentence);
            }
        }
    }

    private void handlePiv(ServiceStatus status) {
        ListMap<String, PraticaVolo> piv = status.getPiv();
        for (Map.Entry entry : piv.entrySet()) {
            String azienda;
            Pratica pratica = (Pratica)((List)entry.getValue()).get(0);
            if (pratica.isHandled() || !this.reseller.match(azienda = pratica.getCodiceReseller()) || !this.missingMisura(pratica)) continue;
            this.checkLateProcessing(pratica, status);
        }
    }

    private void checkLateProcessing(Pratica pratica, ServiceStatus status) {
        PodMap podMap = status.getPodMap();
        String codicePod = pratica.getCodicePod();
        try {
            Pod pod = podMap.getOnly(codicePod);
            this.checkLateProcessing(pratica, pod, status);
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            String key = exc.getKey();
            Message sentence = new Message("check.piv", message);
            sentence.setCss("alert-warning");
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
        }
    }

    private void checkLateProcessing(Pratica pratica, Pod pod, ServiceStatus status) throws DataNotFoundException {
        String codicePod = pod.getCodice();
        this.consolidate(codicePod, status);
        String azienda = pod.getAzienda();
        SpecificaTecnica specificaPratica = pratica.getSpecificaTecnica();
        Date dataTecnica = specificaPratica.getData();
        Date dataMisura = CalendarTools.previousDay(dataTecnica);
        TipoPrestazione tipoPrestazione = pratica.getTipoPrestazione();
        this.handlePrestazione(pratica, pod, status, codicePod, azienda, dataMisura, tipoPrestazione);
    }

    private void consolidate(String codicePod, ServiceStatus status) {
        SplitConsolidamentoStrategy splitConsolidamentoStrategy = new SplitConsolidamentoStrategy(this.anno, this.mese, codicePod, this.configuration, this.misureDao, this.talkManager);
        splitConsolidamentoStrategy.execute(status);
    }

    private void handlePrestazione(Pratica pratica, Pod pod, ServiceStatus status, String codicePod, String azienda, Date dataMisura, TipoPrestazione tipoPrestazione) throws DataNotFoundException {
        SpecificaPrestazione specificaPrestazione = tipoPrestazione.getSpecificaPrestazione(this.prestazioni);
        if (specificaPrestazione != null) {
            try {
                StatusTransaction transaction = new StatusTransaction(azienda, status, this.configuration);
                int ritardo = specificaPrestazione.getRitardo();
                int scostamento = specificaPrestazione.getScostamento();
                this.handleLateProcessing(pod, pratica, dataMisura, ritardo, scostamento, transaction);
                transaction.handleDeferredStatiPod();
                transaction.commit(codicePod);
            }
            catch (StatoPodInvalidoException exc) {
                String messaggio = exc.getMessage();
                String key = exc.getKey();
                this.handleMessage(messaggio, key);
            }
            catch (StatoPodObsoletoException exc) {
                String messaggio = exc.getMessage();
                String key = exc.getKey();
                Date date = exc.getDate();
                String[] params = new String[]{key, this.dataFormat.format(date)};
                this.handleMessage(messaggio, Arrays.asList(params));
            }
            catch (PraticaAnnullataException exc) {
                String messaggio = exc.getMessage();
                String key = exc.getKey();
                this.handleMessage(messaggio, key);
            }
            catch (RuntimeException exc) {
                StrategyHelper.handleRuntimeException(exc, codicePod, "export.gesfile.strategy", this.talkManager, status);
            }
        }
    }

    private void handleMessage(String messaggio, String param) {
        this.handleMessage(messaggio, Arrays.asList(param));
    }

    private void handleMessage(String messaggio, List<String> params) {
        Message sentence = new Message("late.processing", messaggio);
        sentence.setParams(params);
        this.talkManager.addSentence(sentence);
    }

    private void handleLateProcessing(Pod pod, Pratica pratica, Date dataMisura, int ritardo, int scostamento, StatusTransaction transaction) {
        boolean azzeramento;
        Date timeout;
        SpecificaTecnica specificaTecnica;
        Date dataPratica;
        TipoPrestazione tipoPrestazione = pratica.getTipoPrestazione();
        if (tipoPrestazione.checkTardivo(dataPratica = (specificaTecnica = pratica.getSpecificaTecnica()).getData(), timeout = this.configuration.getTimeout(ritardo), azzeramento = pod.isAzzeramento(dataMisura))) {
            if (azzeramento) {
                Pdo pdo = tipoPrestazione.getPdo(pod, pratica, scostamento, this.misureDao);
                this.handleLateProcessing(pratica, pod, pdo, tipoPrestazione, transaction);
            } else {
                try {
                    Mno mno = tipoPrestazione.getMno(pod, pratica, scostamento, PT_HANDLER, this.misureDao);
                    this.handleLateProcessing(pratica, pod, mno, tipoPrestazione, transaction);
                }
                catch (DataNotFoundException exc) {
                    String message = exc.getMessage();
                    String key = exc.getKey();
                    Message sentence = new Message("check.piv", message);
                    sentence.addParam(key);
                    this.talkManager.addSentence(sentence);
                }
            }
        }
    }

    private void handleLateProcessing(Pratica pratica, Pod pod, Mno mno, TipoPrestazione tipoPrestazione, StatusTransaction transaction) {
        try {
            StatoMisure stato;
            String azienda = pod.getAzienda();
            mno.setCdaziend(azienda);
            String flusso = mno.getCodiceFlusso();
            String codicePrestazione = pratica.getCodicePrestazione();
            ServiceStatus status = transaction.getStatus();
            String destinazione = StrategyHelper.getDestinazioneLate(this.configuration, flusso, azienda, codicePrestazione, status);
            tipoPrestazione.handlePrestazioneTardiva(this.funzionalita, destinazione, pod, pratica, mno, transaction, this.misureDao, this.configuration, this.talkManager);
            if (mno.isReal() && !(stato = mno.getStato()).isElaborato()) {
                MnoResult result = new MnoResult(mno, ErroriElaborazione.OK, "");
                if (mno.isPdo2GR()) {
                    transaction.addPdo2GRElaborato(result);
                } else {
                    transaction.addPnoElaborato(result);
                }
            }
        }
        catch (PraticaAnnullataException | StatoPodInvalidoException | StatoPodObsoletoException | DataNotFoundException exc) {
            String message = exc.getMessage();
            String key = exc.getKey();
            Message sentence = new Message("check.piv", message);
            sentence.setCss("alert-warning");
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
        }
    }

    private void handleLateProcessing(Pratica pratica, Pod pod, Pdo pdo, TipoPrestazione tipoPrestazione, StatusTransaction transaction) {
        try {
            StatoMisure stato;
            String azienda = pod.getAzienda();
            pdo.setCdaziend(azienda);
            boolean crm = this.isCrm(azienda, transaction);
            tipoPrestazione.handlePrestazioneTardiva(crm, pod, pratica, pdo, transaction, this.misureDao, this.configuration, this.talkManager);
            if (pdo.isReal() && !(stato = pdo.getStato()).isElaborato()) {
                PdoResult result = new PdoResult(pdo, ErroriElaborazione.OK, "");
                transaction.addPdoElaborato(result);
            }
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            String key = exc.getKey();
            Message sentence = new Message("check.piv", message);
            sentence.setCss("alert-warning");
            sentence.addParam(key);
            this.talkManager.addSentence(sentence);
        }
    }

    private boolean isCrm(String azienda, StatusTransaction transaction) throws DataNotFoundException {
        boolean crm = this.configuration.hasCrm();
        if (crm) {
            SafeMap<String, Reseller> resellers = transaction.getResellers();
            Reseller currentReseller = (Reseller)resellers.get(azienda);
            crm = currentReseller.isCrm();
        }
        return crm;
    }

    private boolean missingMisura(Pratica pratica) {
        boolean value;
        String codicePod = pratica.getCodicePod();
        if (this.misureDao.verifyPdos(codicePod, this.anno, this.mese)) {
            value = false;
        } else {
            SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
            Date dataPratica = specificaTecnica.getData();
            ExclusionCondition condition = new ExclusionCondition(dataPratica);
            Filter<Mno> filter = new Filter<Mno>(condition);
            ArrayList<Mno> misure = new ArrayList<Mno>();
            List<Mno> misurePeriodo = this.misureDao.getPnoPeriodo(this.anno, this.mese, codicePod, StrategyHelper.STATI);
            List<Mno> filtered = filter.filter(misurePeriodo);
            misure.addAll(filtered);
            List<Mno> misurePeriodo2GR = this.misureDao.getPdo2GRFinoMese(this.anno, this.mese, codicePod, StrategyHelper.STATI);
            List<Mno> filtered2GR = filter.filter(misurePeriodo2GR);
            misure.addAll(filtered2GR);
            value = misure.isEmpty();
        }
        return value;
    }
}

