/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.TestConfiguration;
import biz.elabor.prebilling.TestServiceStatus;
import biz.elabor.prebilling.model.ErrorWrapper;
import biz.elabor.prebilling.model.MockOfferteCommerciali;
import biz.elabor.prebilling.model.TipoEstrazione;
import biz.elabor.prebilling.model.TipoLetStd;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.giada.DefaultPodMap;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.services.HelperTest;
import biz.elabor.prebilling.services.PrebillingTestCase;
import biz.elabor.prebilling.services.letture.AggregationMockPrebillingDao;
import biz.elabor.prebilling.services.letture.BaseAggregationStrategy;
import biz.elabor.prebilling.services.letture.TestPivChecker;
import biz.elabor.prebilling.util.MapWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.calendar.DaysOfMonthIterator;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.BasicListMap;
import org.homelinux.elabor.structures.safe.DefaultSafeListMap;
import org.homelinux.elabor.structures.safe.RecordSafeListMap;
import org.homelinux.elabor.structures.safe.SimpleSafeListMap;

public class AggregationStrategyLegaleSolareTest
extends PrebillingTestCase {
    public void testExecute() {
        TalkManager talkManager = new TalkManager();
        Reseller reseller = new Reseller("*", null, null, false, false);
        TestConfiguration configuration = new TestConfiguration();
        TestPivChecker pivChecker = new TestPivChecker();
        BaseAggregationStrategy strategy = new BaseAggregationStrategy(2017, Month.JANUARY, null, reseller, TipoEstrazione.TUTTI, null, talkManager, pivChecker, configuration);
        TestServiceStatus status = new TestServiceStatus(configuration);
        AggregationMockPrebillingDao prebillingDao = new AggregationMockPrebillingDao();
        CalendarMap calendarMap = new CalendarMap(prebillingDao);
        MockOfferteCommerciali offerteCommerciali = new MockOfferteCommerciali();
        status.setCalendarMap(calendarMap, offerteCommerciali, configuration.getIdCalendarioArera());
        ArrayList<Reseller> resellers = new ArrayList<Reseller>();
        resellers.add(new Reseller("azienda", null, "azienda", true, false));
        status.setResellers(resellers);
        DefaultPodMap pods = AggregationStrategyLegaleSolareTest.getPods();
        status.setPodMap(pods);
        RecordSafeListMap<String, Pdo> pdos = AggregationStrategyLegaleSolareTest.getPdos();
        status.setPdo(pdos);
        status.setPiv(new BasicListMap<String, PraticaVolo>());
        SimpleSafeListMap<String, Prestazione> prestazioni = new SimpleSafeListMap<String, Prestazione>("");
        prestazioni.add(new Prestazione("E", "SE3", "PDO", 1, 0, null, null, "", false));
        prestazioni.add(new Prestazione("E", "VT1", "PDO", 1, 0, null, null, "", false));
        prestazioni.add(new Prestazione("E", "VT3", "PDO", 1, 0, null, null, "", false));
        status.setPrestazioni(prestazioni);
        strategy.execute(status);
        Map<TipoLetStd, MapWriter> mdw = status.getMisureDispatcherWriter();
        for (MapWriter entry : mdw.values()) {
            for (List rows : entry) {
                for (String row : rows) {
                    System.out.println(row);
                }
            }
        }
    }

    private static DefaultPodMap getPods() {
        DefaultPodMap pods = new DefaultPodMap();
        int index = 0;
        while (index <= 1) {
            Pod pod = new Pod("pod" + index, true, 1001, "azienda", null, null, true, true, true, null, null, "dispatcher", false, null, false, null, 0.0, 0.0, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "1", 1.0, 1.0, 1.0, false, null);
            pods.add(pod);
            ++index;
        }
        return pods;
    }

    private static RecordSafeListMap<String, Pdo> getPdos() {
        ErrorWrapper error = new ErrorWrapper("pdo", ErroriElaborazione.PDO_NOTFOUND);
        DefaultSafeListMap<String, Pdo> pdos = new DefaultSafeListMap<String, Pdo>(error);
        int index = 0;
        while (index <= 1) {
            RilMese rilMese = new RilMese("pod" + index, 2016, Month.OCTOBER, null);
            DaysOfMonthIterator iterator = new DaysOfMonthIterator(2016, Month.OCTOBER);
            ElaborCalendar calendar = new ElaborCalendar(2016, Month.OCTOBER);
            while (iterator.hasNext()) {
                RilQuarto rilQuarto;
                int quarto;
                int giorno = iterator.next();
                calendar.setGiorno(giorno);
                Date date = calendar.getDate();
                RilGiorno rilGiorno = new RilGiorno(date);
                if (calendar.getGiorno() == 30) {
                    quarto = 0;
                    while (quarto < 100) {
                        rilQuarto = HelperTest.createRilQuarto(quarto, 1.0, 1.0, 1.0, 1.0);
                        rilGiorno.add(rilQuarto);
                        ++quarto;
                    }
                } else {
                    quarto = 0;
                    while (quarto < 96) {
                        rilQuarto = HelperTest.createRilQuarto(quarto, 1.0, 1.0, 1.0, 1.0);
                        rilGiorno.add(rilQuarto);
                        ++quarto;
                    }
                }
                rilMese.add(rilGiorno);
            }
            Pdo pdo = new Pdo(null, false, rilMese, null, null, null, null, null, null, "", "", null, "");
            pdos.add(pdo);
            ++index;
        }
        return pdos;
    }
}

