/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.letture;

import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.letture.PivChecker;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;

public abstract class AbstractPivChecker
implements PivChecker {
    public static PraticaVolo getVirtualPiv(String codicePod, StatusTransaction transaction) throws DataNotFoundException {
        PraticaVolo pratica;
        Map<String, PraticaVolo> virtualPiv = transaction.getVirtualPiv();
        PraticaVolo praticaVirtuale = virtualPiv.get(codicePod);
        try {
            pratica = StrategyHelper.getPiv(codicePod, null, transaction);
        }
        catch (DataNotFoundException exc) {
            pratica = praticaVirtuale;
        }
        if (pratica != praticaVirtuale && praticaVirtuale != null) {
            int errore = ErroriElaborazione.PIV_VIRTUAL_DUPLICATE.ordinal();
            throw new DataNotFoundException("piv.virtualduplicate", codicePod, errore);
        }
        return pratica;
    }
}

