/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.gas;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.services.gas.CsvOutputHandler;
import biz.elabor.prebilling.services.gas.OutputHandler;
import biz.elabor.prebilling.services.gas.XMLFileFilter;
import biz.elabor.prebilling.services.gas.XmlOutputHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.dom.DomHelper;
import org.homelinux.elabor.file.FileSystemTools;
import org.homelinux.elabor.file.InvalidFileFormat;
import org.homelinux.elabor.springtools.web.widgets.AbstractSentence;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.springtools.web.widgets.Warning;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GasService {
    private PrebillingConfiguration configuration;
    private TalkManager talkManager;
    private DocumentBuilder builder;
    private Map<String, CsvOutputHandler> csvOutputMap;

    public GasService(PrebillingConfiguration configuration, TalkManager talkManager) throws ParserConfigurationException {
        this.configuration = configuration;
        this.talkManager = talkManager;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        this.builder = factory.newDocumentBuilder();
        this.csvOutputMap = new HashMap<String, CsvOutputHandler>();
    }

    public boolean execute(PrebillingDao dao, ServiceStatus status) throws IOException {
        String idEsecuzione = status.getIdEsecuzione();
        File inputFolder = this.configuration.getInputFolder();
        File saveFolder = new File(inputFolder, "save");
        saveFolder.mkdirs();
        XMLFileFilter filter = new XMLFileFilter();
        File[] files = inputFolder.listFiles(filter);
        if (files == null || files.length == 0) {
            Message sentence = new Message("TMV-0350", "no.file.exported");
            sentence.setCss("info");
            this.talkManager.addSentence(sentence);
        } else {
            boolean configurationHasCrm = this.configuration.hasCrm();
            File[] fileArray = files;
            int n2 = files.length;
            int n3 = 0;
            while (n3 < n2) {
                AbstractSentence sentence;
                File file = fileArray[n3];
                String pIvaReseller = null;
                String fileName = file.getName();
                try {
                    OutputHandler outputHandler;
                    boolean crm;
                    Document document = this.extractDocument(file);
                    pIvaReseller = GasService.getPivaReseller(document);
                    Reseller reseller = dao.getResellerByPiva(pIvaReseller);
                    boolean bl = crm = configurationHasCrm && reseller.isCrm();
                    if (crm) {
                        outputHandler = new XmlOutputHandler(this.configuration, idEsecuzione);
                    } else {
                        String codice = reseller.getCodice();
                        outputHandler = this.getCsvOutputHandler(idEsecuzione, codice);
                    }
                    String outFileName = this.printD65(document, fileName, outputHandler);
                    this.handleFile(file, outFileName, saveFolder);
                    outputHandler.closePod();
                }
                catch (InvalidFileFormat e2) {
                    sentence = new Message("TMV-0350", "invalid.document.format");
                    sentence.addParam(fileName);
                    sentence.setCss("danger");
                    this.talkManager.addSentence(sentence);
                }
                catch (DataNotFoundException exc) {
                    sentence = new Warning("TMV-0350", "reseller.notfound");
                    sentence.addParam(pIvaReseller);
                    sentence.setCss("alert-danger");
                    this.talkManager.addSentence(sentence);
                }
                ++n3;
            }
        }
        for (CsvOutputHandler handler : this.csvOutputMap.values()) {
            handler.close();
        }
        return false;
    }

    public CsvOutputHandler getCsvOutputHandler(String idEsecuzione, String codice) throws FileNotFoundException {
        CsvOutputHandler handler = this.csvOutputMap.get(codice);
        if (handler == null) {
            handler = new CsvOutputHandler(this.configuration, idEsecuzione, codice);
            this.csvOutputMap.put(codice, handler);
        }
        return handler;
    }

    private static String getPivaReseller(Document document) throws InvalidFileFormat {
        Element docElement = document.getDocumentElement();
        Element element = DomHelper.getElement(docElement, "IdentificativiRichiesta", false);
        return DomHelper.getTextElement(element, "piva_utente");
    }

    private Document extractDocument(File file) throws IOException, InvalidFileFormat {
        Document document;
        try {
            document = this.builder.parse(file);
        }
        catch (SAXException e2) {
            throw new InvalidFileFormat(e2);
        }
        return document;
    }

    private void handleFile(File file, String outFileName, File saveFolder) throws IOException {
        String fileName = file.getName();
        File save = new File(saveFolder, fileName);
        FileSystemTools.copy(file, save);
        file.delete();
        Message sentence = new Message("TMV-0350", "file.exported");
        sentence.addParam(file.getName());
        sentence.addParam(outFileName);
        sentence.setCss("info");
        this.talkManager.addSentence(sentence);
    }

    private String printD65(Document document, String filename, OutputHandler outputHandler) throws IOException, FileNotFoundException {
        Element docElement = document.getDocumentElement();
        String outFileName = null;
        try {
            outFileName = outputHandler.printD65(docElement);
        }
        catch (InvalidFileFormat e2) {
            Message sentence = new Message("TMV-0350", "invalid.document.format");
            sentence.addParam(filename);
            sentence.setCss("danger");
            this.talkManager.addSentence(sentence);
        }
        return outFileName;
    }
}

