/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.consumi;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.consumi.ConsumiMultipodService;
import biz.elabor.prebilling.services.letture.PdoContratto;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ConsumiQuartorariService
extends ConsumiMultipodService {
    public ConsumiQuartorariService(List<String> codiciPod, Date dataInizio, Date dataFine, String reseller, PrebillingDao prebillingDao, GiadaDao giadaDao, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager, boolean excludeStimatoFineConsumi) {
        super(codiciPod, dataInizio, dataFine, reseller, prebillingDao, giadaDao, misureDao, configuration, talkManager, excludeStimatoFineConsumi);
    }

    @Override
    protected void printConsumi(String title, ListMap<Date, PdoContratto> pdoMap) {
        File dispatcherOutputFolder = this.configuration.getDispatcherOutputFolder();
        File outputFolder = new File(dispatcherOutputFolder, "consumi");
        outputFolder.mkdirs();
        String timestamp = StrategyCommonHelper.getTimestampFormat().format(new Date());
        this.file = new File(outputFolder, "consumi_quartorari_attiva_" + title + "_" + timestamp + ".csv");
        DateFormat dateFormat = StrategyHelper.getDataFormat();
        String fmtStartDate = dateFormat.format(this.dataInizio);
        String fmtEndDate = dateFormat.format(this.dataFine);
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (PrintWriter writer = new PrintWriter(this.file);){
                writer.println("Data inizio;" + fmtStartDate);
                writer.println("Data fine;" + fmtEndDate);
                writer.println("Esito;consumi quartorari calcolati dal " + fmtStartDate + " al " + fmtEndDate + (title.equals("multipod") ? "" : " per il PoD " + title));
                writer.println();
                ConsumiQuartorariService.printTestata(writer);
                Date dataInizioMese = CalendarTools.getStartOfMonth(this.dataInizio);
                while (!dataInizioMese.after(this.dataFine)) {
                    List pdos = pdoMap.contains(dataInizioMese) ? (List)pdoMap.get(dataInizioMese) : Arrays.asList(new PdoContratto[0]);
                    this.printConsumiMese(writer, dataInizioMese, pdos, dateFormat);
                    dataInizioMese = CalendarTools.getNextMese(dataInizioMese);
                }
                Message sentence = new Message("CONSUMI_MULTIPOD", "consumi.calcolati");
                sentence.addParam(fmtStartDate);
                sentence.addParam(fmtEndDate);
                sentence.addParam("");
                this.talkManager.addSentence(sentence);
                sentence = new Message("CONSUMI_MULTIPOD", "procedure.successful");
                this.talkManager.addSentence(sentence);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException exc) {
            Message sentence = new Message("CONSUMI_MULTIPOD", "file.createFailed");
            sentence.addParam(this.file.getAbsolutePath());
            this.talkManager.addSentence(sentence);
        }
    }

    private void printConsumiMese(PrintWriter writer, Date dataInizioMese, List<PdoContratto> pdos, DateFormat dateFormat) {
        DecimalFormat doubleFormat = StrategyHelper.getItEnergyFormat();
        ElaborCalendar calendar = new ElaborCalendar(dataInizioMese);
        Month mese = calendar.getMese();
        do {
            Date date;
            if (!(date = calendar.getDate()).before(this.dataInizio) && !date.after(this.dataFine)) {
                ConsumiQuartorariService.printConsumiGiorno(writer, date, pdos, dateFormat, doubleFormat);
            }
            calendar.addGiorni(1);
        } while (calendar.getMese().equals((Object)mese));
    }

    private static void printConsumiGiorno(PrintWriter writer, Date date, List<PdoContratto> pdos, DateFormat dateFormat, DecimalFormat doubleFormat) {
        for (PdoContratto pdoContratto : pdos) {
            RilGiorno rilGiorno;
            Pdo pdo = pdoContratto.getPdo();
            RilMese rilMese = pdo.getRilMese();
            if (rilMese == null || (rilGiorno = rilMese.getRilGiorno(date)) == null) continue;
            writer.print(dateFormat.format(date));
            writer.print(";");
            String codicePod = pdo.getCodicePod();
            writer.print(codicePod);
            for (RilQuarto rilQuarto : rilGiorno) {
                Double attivaQuarto = rilQuarto.getAttiva();
                double ka = rilQuarto.getKa();
                double attiva = attivaQuarto == null ? 0.0 : attivaQuarto * ka;
                writer.print(";");
                writer.print(doubleFormat.format(attiva));
            }
            writer.println();
        }
    }

    private static void printTestata(PrintWriter writer) {
        writer.print("data;pod");
        int index = 1;
        while (index <= 100) {
            writer.print(";");
            writer.print(index);
            ++index;
        }
        writer.println();
    }
}

