/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.consumi;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.model.misure.RilQuartoType;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.consumi.ConsumiMultipodService;
import biz.elabor.prebilling.services.letture.ConsumiHelper;
import biz.elabor.prebilling.services.letture.PdoContratto;
import biz.elabor.prebilling.services.letture.PodConsumi;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.TappoIterator;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ConsumiOrariService
extends ConsumiMultipodService {
    private static final String CONSUMI_ORARI = "CONSUMI_ORARI";
    private static final Date END_TIME = CalendarTools.getEndOfTime();
    private static final PdoContratto TAPPO = new PdoContratto(null, new PodConsumi(null, null, END_TIME, END_TIME, null, null, null, 0.0, 0.0, 0.0));

    public ConsumiOrariService(List<String> codiciPod, Date dataInizio, Date dataFine, String reseller, PrebillingDao prebillingDao, GiadaDao giadaDao, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager, boolean excludeStimatoFineConsumi) {
        super(codiciPod, dataInizio, dataFine, reseller, prebillingDao, giadaDao, misureDao, configuration, talkManager, excludeStimatoFineConsumi);
    }

    @Override
    protected void printConsumi(String title, ListMap<Date, PdoContratto> pdoMap) {
        File dispatcherOutputFolder = this.configuration.getDispatcherOutputFolder();
        File outputFolder = new File(dispatcherOutputFolder, "consumi");
        outputFolder.mkdirs();
        String timestamp = StrategyCommonHelper.getTimestampFormat().format(new Date());
        this.file = new File(outputFolder, "consumi_attiva_" + title + "_" + timestamp + ".csv");
        DateFormat dateFormat = StrategyHelper.getDataFormat();
        String fmtStartDate = dateFormat.format(this.dataInizio);
        String fmtEndDate = dateFormat.format(this.dataFine);
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (PrintWriter writer = new PrintWriter(this.file);){
                writer.println("Data inizio;" + fmtStartDate);
                writer.println("Data fine;" + fmtEndDate);
                writer.println("Esito;consumi calcolati dal " + fmtStartDate + " al " + fmtEndDate + (title.equals("multipod") ? "" : " per il PoD " + title));
                writer.println();
                this.printTestata(writer);
                double kPeriodo = 0.0;
                Date dataInizioMese = CalendarTools.getStartOfMonth(this.dataInizio);
                while (!dataInizioMese.after(this.dataFine)) {
                    List pdos = pdoMap.contains(dataInizioMese) ? (List)pdoMap.get(dataInizioMese) : Arrays.asList(new PdoContratto[0]);
                    double kMese = this.printConsumiMese(writer, dataInizioMese, pdos, dateFormat);
                    kPeriodo = ConsumiHelper.updateK(kPeriodo, kMese);
                    dataInizioMese = CalendarTools.getNextMese(dataInizioMese);
                }
                Message sentence = new Message(CONSUMI_ORARI, "consumi.calcolati");
                sentence.addParam(fmtStartDate);
                sentence.addParam(fmtEndDate);
                sentence.addParam(this.codiciPod.size() == 1 ? ConsumiHelper.getKMessage(kPeriodo) : "");
                this.talkManager.addSentence(sentence);
                sentence = new Message(CONSUMI_ORARI, "procedure.successful");
                this.talkManager.addSentence(sentence);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException exc) {
            Message sentence = new Message(CONSUMI_ORARI, "file.createFailed");
            sentence.addParam(this.file.getAbsolutePath());
            this.talkManager.addSentence(sentence);
        }
    }

    private double printConsumiMese(PrintWriter writer, Date dataInizioMese, List<PdoContratto> pdos, DateFormat dateFormat) {
        DecimalFormat doubleFormat = StrategyHelper.getItEnergyFormat();
        ElaborCalendar calendar = new ElaborCalendar(dataInizioMese);
        Month mese = calendar.getMese();
        double kMese = 0.0;
        int giorno = 1;
        do {
            Date date;
            if ((date = calendar.getDate()).before(this.dataInizio) || date.after(this.dataFine)) {
                calendar.addGiorni(1);
            } else {
                do {
                    int ora = calendar.getOra();
                    int startIndex = calendar.getIndex();
                    double kOra = this.printConsumiOra(writer, date, ora, startIndex, pdos, dateFormat, doubleFormat);
                    kMese = ConsumiHelper.updateK(kMese, kOra);
                    calendar.addOre(1);
                } while (calendar.getGiorno() == giorno);
            }
            ++giorno;
        } while (calendar.getMese().equals((Object)mese));
        return kMese;
    }

    private double printConsumiOra(PrintWriter writer, Date date, int ora, int startIndex, List<PdoContratto> pdos, DateFormat dateFormat, DecimalFormat doubleFormat) {
        int numero = 0;
        double kOra = 0.0;
        writer.print(dateFormat.format(date));
        writer.print(";");
        writer.print(ora);
        double totale = 0.0;
        TappoIterator<PdoContratto> pdoIterator = new TappoIterator<PdoContratto>(pdos, TAPPO);
        PdoContratto pdoContratto = pdoIterator.next();
        for (String codicePod : this.codiciPod) {
            RilQuartoType type;
            RilGiorno rilGiorno;
            Pdo pdo = pdoContratto.getPdo();
            PodConsumi contratto = pdoContratto.getContratto();
            if (pdo != null && codicePod.equals(pdo.getCodicePod())) {
                RilMese rilMese = pdo.getRilMese();
                rilGiorno = rilMese.getRilGiorno(date);
                pdoContratto = pdoIterator.next();
            } else {
                rilGiorno = null;
            }
            writer.print(";");
            double attivaOra = 0.0;
            if (rilGiorno == null) {
                Date dataInizioContratto = contratto.getDataInizio();
                Date dataFineContratto = contratto.getDataFine();
                type = date.before(dataInizioContratto) || date.after(dataFineContratto) ? RilQuartoType.REALE : RilQuartoType.MANCANTE;
            } else {
                type = RilQuartoType.NON_CONTRATTUALIZZATO;
                int indexQuarto = startIndex;
                while (indexQuarto < startIndex + 4) {
                    RilQuarto rilQuarto = (RilQuarto)rilGiorno.get(indexQuarto);
                    Double attivaQuarto = rilQuarto.getAttiva();
                    double ka = rilQuarto.getKa();
                    kOra = ConsumiHelper.updateK(kOra, ka);
                    attivaOra += attivaQuarto == null ? 0.0 : attivaQuarto * ka;
                    type = rilQuarto.updateType(type);
                    ++indexQuarto;
                }
                if (type != RilQuartoType.NON_CONTRATTUALIZZATO) {
                    totale += attivaOra;
                    ++numero;
                    writer.print(doubleFormat.format(attivaOra));
                }
            }
            writer.print(";");
            writer.print(type.getMarker());
        }
        if (this.codiciPod.size() > 1) {
            writer.print(";");
            writer.print(doubleFormat.format(totale));
            writer.print(";");
            writer.print(numero);
        }
        writer.println();
        return kOra;
    }

    private void printTestata(PrintWriter writer) {
        writer.print("data;ora");
        for (String codicePod : this.codiciPod) {
            writer.print(";");
            writer.print(codicePod);
            writer.print(";Tipo");
        }
        if (this.codiciPod.size() > 1) {
            writer.print(";totale;numero");
        }
        writer.println();
    }
}

