/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.consumi;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.config.BasicPrebillingConfiguration;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.config.map.ConfigurationInstance;
import biz.elabor.prebilling.dao.GiadaDao;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.dao.PrebillingDao;
import biz.elabor.prebilling.services.consumi.ConsumiOrariService;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.web.common.JsonRequestHandler;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class ConsumiOrariJsonHandler
implements JsonRequestHandler {
    private final List<String> codiciPod;
    private final String dataInizioStr;
    private final String dataFineStr;
    private final String reseller;
    private final TalkManager talkManager;

    public ConsumiOrariJsonHandler(List<String> codiciPod, String dataInizioStr, String dataFineStr, String reseller, TalkManager talkManager) {
        this.codiciPod = codiciPod;
        this.dataInizioStr = dataInizioStr;
        this.dataFineStr = dataFineStr;
        this.reseller = reseller;
        this.talkManager = talkManager;
    }

    @Override
    public String handleRequest(ConfigurationInstance instance) throws InvalidParameterValue {
        DateFormat dateFormat = StrategyCommonHelper.getAlternateDateFormat();
        Date dataInizio = ControllerHelper.checkData("datainizio", this.dataInizioStr, dateFormat);
        Date dataFine = ControllerHelper.checkData("datafine", this.dataFineStr, dateFormat);
        PrebillingDao prebillingDao = instance.getPrebillingDao();
        GiadaDao giadaDao = instance.getGiadaDao();
        MisureDao misureDao = instance.getMisureDao();
        PrebillingConfiguration configuration = instance.getConfiguration();
        ConsumiOrariService service = new ConsumiOrariService(this.codiciPod, dataInizio, dataFine, this.reseller, prebillingDao, giadaDao, misureDao, configuration, this.talkManager, false);
        service.execute();
        File file = service.getFile();
        return JsonHelper.buildMessage((BasicPrebillingConfiguration)configuration, service, file, this.talkManager);
    }
}

