/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.consolidamento;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.services.ServiceStrategy;
import biz.elabor.prebilling.services.consolidamento.PdoSplitHandler;
import biz.elabor.prebilling.services.consolidamento.PnoSplitHandler;
import biz.elabor.prebilling.services.consolidamento.SplitHandler;
import biz.elabor.prebilling.web.xml.Partition;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class SplitConsolidamentoStrategy
implements ServiceStrategy {
    private final int anno;
    private final Month mese;
    private final MisureDao misureDao;
    private final TalkManager talkManager;
    private final String onlyPod;
    private final int prefixLength;
    private final int maxPrefixCount;
    private final PrebillingConfiguration configuration;

    public SplitConsolidamentoStrategy(int anno, Month mese, String onlyPod, PrebillingConfiguration configuration, MisureDao misureDao, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.onlyPod = onlyPod;
        this.misureDao = misureDao;
        this.talkManager = talkManager;
        this.configuration = configuration;
        this.prefixLength = configuration.getPrefixLength();
        this.maxPrefixCount = configuration.getMaxPrefixCount();
    }

    @Override
    public boolean execute(ServiceStatus status) {
        this.executePno(status);
        this.executePdo(status);
        return true;
    }

    private void executePno(ServiceStatus status) {
        PnoSplitHandler handler = new PnoSplitHandler(this.misureDao, this.configuration, this.talkManager);
        this.execute(handler, status);
    }

    private void executePdo(ServiceStatus status) {
        PdoSplitHandler handler = new PdoSplitHandler(this.misureDao, this.configuration, this.talkManager);
        this.execute(handler, status);
    }

    private void execute(SplitHandler handler, ServiceStatus status) {
        List<ElaborCalendar> months = handler.getMonths(this.onlyPod, this.anno, this.mese);
        for (ElaborCalendar month : months) {
            List<Partition> partitions = handler.getPartitions(this.onlyPod, month, "", this.prefixLength);
            this.execute(month, partitions, handler, status);
        }
    }

    private void execute(ElaborCalendar month, List<Partition> partitions, SplitHandler handler, ServiceStatus status) {
        for (Partition partition : partitions) {
            this.execute(month, partition, handler, status);
        }
    }

    private void execute(ElaborCalendar month, Partition partition, SplitHandler handler, ServiceStatus status) {
        String prefix = partition.getPrefix();
        int count = partition.getCount();
        if (count > this.maxPrefixCount) {
            List<Partition> partitions = handler.getPartitions(this.onlyPod, month, prefix, prefix.length() + 1);
            this.execute(month, partitions, handler, status);
        } else {
            handler.execute(this.onlyPod, month, prefix, status);
        }
    }
}

