/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.consolidamento;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.services.StrategiesManager;
import biz.elabor.prebilling.services.consolidamento.AbstractSplitHandler;
import biz.elabor.prebilling.services.consolidamento.ConsolidatePdoStrategy;
import biz.elabor.prebilling.services.consolidamento.GetPdoConsolidamentoStrategy;
import biz.elabor.prebilling.services.consolidamento.RecordStatoConsolidamentoStrategy;
import biz.elabor.prebilling.web.xml.Partition;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

class PdoSplitHandler
extends AbstractSplitHandler {
    public PdoSplitHandler(MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) {
        super(misureDao, configuration, talkManager);
    }

    @Override
    public List<ElaborCalendar> getMonths(String onlyPod, int anno, Month mese) {
        return this.misureDao.getPdoMonths(onlyPod, anno, mese);
    }

    @Override
    public List<Partition> getPartitions(String onlyPod, ElaborCalendar month, String currPrefix, int prefixLength) {
        return this.misureDao.getPdo2GPartitions(onlyPod, month, currPrefix, prefixLength);
    }

    @Override
    protected StrategiesManager buildStrategies(String onlyPod, ElaborCalendar month, String prefix) {
        StrategiesManager manager = new StrategiesManager(this.configuration);
        manager.addStrategy(new GetPdoConsolidamentoStrategy(onlyPod, month, prefix, this.misureDao));
        manager.addStrategy(new ConsolidatePdoStrategy(month, this.talkManager));
        manager.addStrategy(new RecordStatoConsolidamentoStrategy(this.misureDao, this.talkManager));
        return manager;
    }
}

