/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.consolidamento;

import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.statomisure.MnoResult;
import biz.elabor.prebilling.services.consolidamento.ConsolidateAbstractStrategy;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.ListMap;

public class ConsolidatePdoStrategy
extends ConsolidateAbstractStrategy {
    private ListMap<String, Mno> pnoConsolidamento;

    public ConsolidatePdoStrategy(ElaborCalendar month, TalkManager talkManager) {
        super(month, talkManager);
    }

    @Override
    public boolean execute(ServiceStatus status) {
        ListMap<String, Mno> pdoConsolidamento = status.getPdoConsolidamento();
        this.pnoConsolidamento = status.getMnoConsolidamento();
        this.execute(pdoConsolidamento, status);
        return true;
    }

    @Override
    protected void addObsoleto(ServiceStatus status, MnoResult result) {
        status.addPdo2gObsoleto(result);
    }

    @Override
    protected void addSospeso(ServiceStatus status, MnoResult result) {
        status.addPdo2gSospeso(result);
    }

    @Override
    protected void addElaborato(ServiceStatus status, MnoResult result) {
        status.addPdo2gElaborato(result);
    }

    @Override
    protected void addEscluso(ServiceStatus status, MnoResult result) {
        status.addPdo2gEscluso(result);
    }

    @Override
    protected boolean checkConsolidate(Mno mno) {
        String regime = mno.getRegime();
        regime = regime == null ? "" : regime.trim();
        return regime.equalsIgnoreCase("NR");
    }

    @Override
    protected void extra(String codicePod, List<Mno> misure) {
        List misureExtra;
        if (!misure.isEmpty() && this.pnoConsolidamento != null && (misureExtra = (List)this.pnoConsolidamento.get(codicePod)) != null && !misureExtra.isEmpty()) {
            Date dataUltimaMisura = misure.get(0).getDataMisura();
            Mno ultimaExtra = (Mno)misureExtra.get(0);
            Date dataUltimaExtra = ultimaExtra.getDataMisura();
            if (!dataUltimaExtra.before(dataUltimaMisura)) {
                misure.add(0, ultimaExtra);
            }
        }
    }
}

