/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common.statopod;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.statopod.AbstractBasicStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.model.statopod.SwitchOutStatoPod;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.AbstractStatoPodHandler;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public class PnoSwitchoutStatoPodHandler
extends AbstractStatoPodHandler<MisuraPod> {
    private static final String FLUSSO = "PNO";
    public static final List<String> FLUSSI = Arrays.asList("PNO");

    public PnoSwitchoutStatoPodHandler(MisureDao misureDao) {
        super("E", misureDao);
    }

    @Override
    public AbstractBasicStatoPod buildStatoPod(Prestazione prestazione, String flusso, String cpGestore, String cpUtente, MisuraPod misura, StatoPod riferimento, Date dataMovimento, String idMoovimento, int nuprogre) {
        String tabella = StrategyHelper.FLUSSI_POD_ORARI.contains(flusso) ? "MISURE_POD_ORARI" : "MISURE_POD_NON_ORARI";
        return new SwitchOutStatoPod(prestazione, cpGestore, cpUtente, misura, riferimento, flusso, tabella, nuprogre);
    }

    public void check(SafeListMap<String, Prestazione> prestazioni) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        this.check(prestazioni, StrategyHelper.PNO_CDUNIPRE_LIST, FLUSSI);
    }
}

