/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common.statopod;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.misure.D65StatoPod;
import biz.elabor.prebilling.model.misure.DateContainer;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.model.statopod.AbstractBasicStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.SegnaleNotHandledException;
import biz.elabor.prebilling.model.statopod.SegnalePrestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.PrestazioneNotFoundException;
import biz.elabor.prebilling.services.common.statopod.NullReferenceHandler;
import biz.elabor.prebilling.services.common.statopod.NullStatoPodChecker;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.ReferenceHandler;
import biz.elabor.prebilling.services.common.statopod.StatoPodChecker;
import biz.elabor.prebilling.services.common.statopod.StatoPodHandler;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.structures.listmap.SafeListMap;

public abstract class AbstractStatoPodHandler<S extends D65StatoPod & DateContainer>
implements StatoPodHandler<S> {
    private final String servizio;
    private final MisureDao misureDao;
    private final Map<String, Integer> nuprogreMap;
    private final DateFormat dateFormat;
    protected int offset;

    public AbstractStatoPodHandler(String servizio, MisureDao misureDao) {
        this.servizio = servizio;
        this.misureDao = misureDao;
        this.nuprogreMap = new HashMap<String, Integer>();
        this.dateFormat = StrategyHelper.getDataFormat();
        this.offset = 0;
    }

    public String getCodiceFlusso(S current) {
        return current.getCodiceFlusso();
    }

    public void handleStato(S current, String codicePrestazione, String codicePratica, StatusTransaction transaction) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        Date data = current.getDataMisura();
        NullReferenceHandler referenceHandler = new NullReferenceHandler();
        this.handleStato(current, codicePrestazione, codicePratica, data, data, transaction, referenceHandler);
    }

    public void handleStato(S current, String codicePrestazione, String codicePratica, StatusTransaction transaction, ReferenceHandler<S> referenceHandler) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        Date data = current.getDataMisura();
        this.handleStato(current, codicePrestazione, codicePratica, data, data, transaction, referenceHandler);
    }

    public void handleStato(S current, String codicePrestazione, String codicePratica, Date dataMovimento, Date dataMisura, StatusTransaction transaction) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        NullReferenceHandler referenceHandler = new NullReferenceHandler();
        this.handleStato(current, codicePrestazione, codicePratica, dataMovimento, dataMisura, transaction, referenceHandler);
    }

    public void handleStato(S current, String codicePrestazione, String codicePratica, Date dataMovimento, Date dataMisura, StatusTransaction transaction, ReferenceHandler<S> referenceHandler) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        String flusso = this.getCodiceFlusso(current);
        NullStatoPodChecker checker = new NullStatoPodChecker();
        this.handleStato(current, codicePrestazione, flusso, codicePratica, dataMovimento, dataMisura, null, transaction, checker, referenceHandler);
    }

    public void handleStato(S current, String codicePrestazione, String flusso, String codicePratica, Date dataMovimento, Date dataMisura, String idMovimento, StatusTransaction transaction, StatoPodChecker<S> checker, ReferenceHandler<S> referenceHandler) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        String codicePod = current.getCodicePod();
        int nuprogre = this.getNuprogre(codicePod, dataMovimento, referenceHandler);
        this.handleStato(current, codicePrestazione, flusso, codicePratica, dataMovimento, dataMisura, idMovimento, transaction, checker, nuprogre, referenceHandler);
    }

    protected int getNuprogre(String codicePod, Date dataMovimento, ReferenceHandler<S> referenceHandler) {
        String key = String.valueOf(codicePod) + "|" + this.dateFormat.format(dataMovimento);
        Integer lastNuprogre = this.nuprogreMap.get(key);
        int nuprogre = lastNuprogre == null ? referenceHandler.getNuprogre(this, dataMovimento, codicePod) : lastNuprogre + 1;
        this.nuprogreMap.put(key, nuprogre);
        return nuprogre;
    }

    @Override
    public int getNuprogre(Date dataMovimento, String codicePod) {
        return this.misureDao.getNuprogre(this.servizio, codicePod, dataMovimento);
    }

    protected void handleStato(S current, String codicePrestazione, String flusso, String codicePratica, Date dataMovimento, Date dataMisura, String idMovimento, StatusTransaction transaction, StatoPodChecker<S> checker, int startNp, ReferenceHandler<S> referenceHandler) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        ArrayList<StatoPod> statiPod = new ArrayList<StatoPod>();
        this.handleStato(current, codicePrestazione, flusso, codicePratica, dataMovimento, dataMisura, idMovimento, transaction, checker, startNp, statiPod, referenceHandler);
        transaction.addStatiPod(statiPod);
    }

    private void handleStato(S current, String codicePrestazione, String flusso, String codicePratica, Date dataMovimento, Date dataMisura, String idMovimento, StatusTransaction transaction, StatoPodChecker<S> checker, int startNp, List<StatoPod> statiPod, ReferenceHandler<S> referenceHandler) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        List prestList;
        boolean ok = true;
        int nuprogre = startNp;
        String codicePod = current.getCodicePod();
        SafeListMap<String, Prestazione> prestazioni = transaction.getPrestazioni();
        String key = Prestazione.getKey(this.servizio, codicePrestazione, flusso);
        try {
            prestList = (List)prestazioni.get(key);
        }
        catch (DataNotFoundException exc) {
            String message = exc.getMessage();
            int code = exc.getError();
            throw new DataNotFoundException(message, String.valueOf(key) + "|" + codicePod, code);
        }
        Iterator iterator = prestList.iterator();
        while (ok && iterator.hasNext()) {
            Prestazione prestazione = (Prestazione)iterator.next();
            SegnalePrestazione segnale = prestazione.getSegnale();
            StatoPod riferimento = referenceHandler.getStatoRiferimento(this, current, codicePrestazione, codicePratica, segnale, prestazioni, this.servizio, dataMovimento);
            if (riferimento == null) continue;
            if (riferimento.isPraticaAnnullata()) {
                throw new PraticaAnnullataException(codicePod, codicePrestazione);
            }
            if (AbstractStatoPodHandler.checkDataCessazione(riferimento)) {
                if (AbstractStatoPodHandler.checkDataRiferimento(dataMovimento, riferimento)) {
                    checker.check(current, riferimento, codicePrestazione);
                    String cpUtente = riferimento.getCpUtente();
                    String cpGestore = segnale.getCpGestore(codicePratica, riferimento);
                    AbstractBasicStatoPod statoPod = this.buildStatoPod(prestazione, flusso, cpGestore, cpUtente, current, riferimento, dataMisura, idMovimento, ++nuprogre);
                    statiPod.add(statoPod);
                    AbstractStatoPodHandler.handleStatoRichiestaMovimentoRiferimento(prestazione, riferimento, transaction);
                    continue;
                }
                throw new StatoPodInvalidoException("statopod.invalido", ErroriElaborazione.STATOPOD_INVALIDO, codicePod, codicePrestazione);
            }
            throw new StatoPodInvalidoException("statopod.cessato", ErroriElaborazione.STATOPOD_CESSATO, codicePod, codicePrestazione);
        }
    }

    @Override
    public StatoPod getStatoRiferimento(S current, String codicePrestazione, String codicePratica, SegnalePrestazione segnale, Date dataMovimento, StatoPod tecStatoPod) throws DataNotFoundException {
        return segnale.getStatoPod(this.servizio, codicePrestazione, codicePratica, (D65StatoPod)current, dataMovimento, this.misureDao, tecStatoPod);
    }

    private static void handleStatoRichiestaMovimentoRiferimento(Prestazione prestazione, StatoPod riferimento, StatusTransaction transaction) {
        String statoRicMovRif = prestazione.getStatoRicMovRif();
        if (!statoRicMovRif.isEmpty()) {
            transaction.addUpdateStatoRichiesta(riferimento, statoRicMovRif);
        }
    }

    private static boolean checkDataRiferimento(Date dataMovimento, StatoPod riferimento) {
        Date dataRiferimento = riferimento.getDataMovimento();
        return !dataRiferimento.after(dataMovimento);
    }

    private static boolean checkDataCessazione(StatoPod statoPod) {
        return statoPod.getDataCessazione() == null;
    }

    public void check(SafeListMap<String, Prestazione> prestazioni, List<String> codiciPrestazione, List<String> flussi) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        HashMap<String, List<String>> mappaPrestazioni = new HashMap<String, List<String>>();
        for (String codicePrestazione : codiciPrestazione) {
            mappaPrestazioni.put(codicePrestazione, flussi);
        }
        this.check(prestazioni, mappaPrestazioni);
    }

    public void check(SafeListMap<String, Prestazione> prestazioni, Map<String, List<String>> mappaPrestazioni) throws SegnaleNotHandledException, PrestazioneNotFoundException {
        for (Map.Entry<String, List<String>> entry : mappaPrestazioni.entrySet()) {
            String codicePrestazione = entry.getKey();
            for (String flusso : entry.getValue()) {
                String key = Prestazione.getKey(this.servizio, codicePrestazione, flusso);
                try {
                    List prestList = (List)prestazioni.get(key);
                    for (Prestazione prestazione : prestList) {
                        SegnalePrestazione segnale = prestazione.getSegnale();
                        if (segnale != null) continue;
                        throw new SegnaleNotHandledException(prestazione);
                    }
                }
                catch (DataNotFoundException exc) {
                    throw new PrestazioneNotFoundException(key);
                }
            }
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

