/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.AbstractWriteSwitchoutService;
import biz.elabor.prebilling.services.xml.export.ExportXmlHelper;
import biz.elabor.prebilling.util.MapWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class WriteXmlSwitchoutService
extends AbstractWriteSwitchoutService {
    private final MapWriter writer;
    private final PrebillingConfiguration configuration;
    private final DateFormat longDateFormat;
    private final DateFormat dateFormat;
    private final DecimalFormat energyFormat;
    private final String codicePrestazione;

    public WriteXmlSwitchoutService(String codicePrestazione, MapWriter writer, PrebillingConfiguration configuration) {
        this.writer = writer;
        this.configuration = configuration;
        this.longDateFormat = StrategyHelper.getFullDateFormat();
        this.dateFormat = StrategyHelper.getDataFormat();
        this.energyFormat = StrategyHelper.getUsEnergyFormat();
        this.codicePrestazione = codicePrestazione;
    }

    @Override
    public void write(MisuraPod misuraPod) {
        Pod pod = misuraPod.getPod();
        Map<String, Double> lastMap = ExportXmlHelper.getLastMap(pod);
        this.printMisura(misuraPod, lastMap);
    }

    private void printMisura(MisuraPod misuraPod, Map<String, Double> valueMap) {
        String codicePod = misuraPod.getCodicePod();
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
        this.writer.print(codicePod, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", "\n");
        this.writer.print(codicePod, "<FlussoMisure xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" CodFlusso=\"D65\">", "\n");
        this.writer.print(codicePod, "<CodProcesso>" + this.codicePrestazione + "</CodProcesso>", "\n");
        this.exportDatiPod(misuraPod, valueMap);
        this.writer.print(codicePod, "</FlussoMisure>", "\n");
    }

    private void exportDatiPod(MisuraPod misuraPod, Map<String, Double> valueMap) {
        Map<String, Map<String, String>> datiPod = misuraPod.getDatiPod();
        Map<String, String> misuraOrig = datiPod.get("Misura");
        Misura misuraValue = misuraPod.getMisura();
        StrategyHelper.fixPotenza(misuraOrig, misuraValue);
        String codicePod = misuraPod.getCodicePod();
        this.writer.print(codicePod, "<DatiPod>", "\n");
        this.writer.print(codicePod, "<Pod>" + codicePod + "</Pod>", "\n");
        Date date = misuraPod.getDataMisura();
        String formattedDate = this.dateFormat.format(date);
        this.writer.print(codicePod, "<DataMisura>" + formattedDate + "</DataMisura>", "\n");
        boolean printMisura = false;
        String tipoDato = null;
        for (String nomeDati : datiPod.keySet()) {
            Map<String, String> mappaDettagli = datiPod.get(nomeDati);
            if (nomeDati.equals("Curva") || nomeDati.equals("Misura") && misuraPod.useConsumi()) {
                tipoDato = mappaDettagli.get("TipoDato");
                printMisura = true;
                continue;
            }
            double ka = misuraPod.getKa().doubleValue();
            double kr = misuraPod.getKr().doubleValue();
            double kp = misuraPod.getKp().doubleValue();
            this.writer.print(codicePod, "<" + nomeDati + ">", "\n");
            Set<String> banned = StrategyHelper.buildBanned(misuraPod);
            boolean truncate = this.configuration.isTrunking();
            StrategyHelper.printValueMap(codicePod, mappaDettagli, valueMap, banned, truncate, this.energyFormat, this.configuration, this.writer, this.longDateFormat, this.dateFormat, ka, kr, kp);
            if (!nomeDati.equals("Misura") && misuraPod.isForfait()) {
                Pod pod = misuraPod.getPod();
                this.writer.print(codicePod, "<MatrAtt>" + pod.getMatricolaAttiva() + "</MatrAtt>", "\n");
            }
            if (nomeDati.equals("Misura") && misuraPod.isForfait()) {
                this.writer.print(codicePod, "<TipoDato>E</TipoDato>", "\n");
            }
            this.writer.print(codicePod, "</" + nomeDati + ">", "\n");
        }
        if (printMisura) {
            this.writer.print(codicePod, "<Misura>", "\n");
            Misura datiMisura = misuraPod.getMisura();
            this.writer.print(codicePod, "<EaF1>" + this.formatAttiva(datiMisura, FasciaOraria.F1) + "</EaF1>", "\n");
            this.writer.print(codicePod, "<EaF2>" + this.formatAttiva(datiMisura, FasciaOraria.F2) + "</EaF2>", "\n");
            this.writer.print(codicePod, "<EaF3>" + this.formatAttiva(datiMisura, FasciaOraria.F3) + "</EaF3>", "\n");
            this.writer.print(codicePod, "<ErF1>" + this.formatReattiva(datiMisura, FasciaOraria.F1) + "</ErF1>", "\n");
            this.writer.print(codicePod, "<ErF2>" + this.formatReattiva(datiMisura, FasciaOraria.F2) + "</ErF2>", "\n");
            this.writer.print(codicePod, "<ErF3>" + this.formatReattiva(datiMisura, FasciaOraria.F3) + "</ErF3>", "\n");
            this.writer.print(codicePod, "<PotF1>" + this.formatPotenza(datiMisura, FasciaOraria.F1) + "</PotF1>", "\n");
            this.writer.print(codicePod, "<PotF2>" + this.formatPotenza(datiMisura, FasciaOraria.F2) + "</PotF2>", "\n");
            this.writer.print(codicePod, "<PotF3>" + this.formatPotenza(datiMisura, FasciaOraria.F3) + "</PotF3>", "\n");
            if (tipoDato != null) {
                this.writer.print(codicePod, "<TipoDato>" + tipoDato + "</TipoDato>", "\n");
            }
            this.writer.print(codicePod, "</Misura>", "\n");
        }
        this.writer.print(codicePod, "</DatiPod>", "\n");
    }

    private String formatAttiva(Misura datiMisura, FasciaOraria fascia) {
        return this.energyFormat.format(datiMisura.getAttiva(fascia).getNetto());
    }

    private String formatReattiva(Misura datiMisura, FasciaOraria fascia) {
        return this.energyFormat.format(datiMisura.getReattiva(fascia).getNetto());
    }

    private String formatPotenza(Misura datiMisura, FasciaOraria fascia) {
        return this.energyFormat.format(datiMisura.getPotenza(fascia).getNetto());
    }
}

