/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.misure.model.fasce.FasciaOraria;
import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraD65;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Trattamento;
import biz.elabor.prebilling.services.common.AbstractWriteSwitchoutService;
import biz.elabor.prebilling.util.MapWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.homelinux.elabor.text.Format;
import org.homelinux.elabor.tools.MathUtils;

public class WriteCsvSwitchoutService
extends AbstractWriteSwitchoutService {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final DecimalFormat DOUBLE_EXPORT_FORMAT = Format.newDecimalFormat(Locale.ITALIAN, "+000000000.000");
    private final MapWriter writer;
    private final PrebillingConfiguration configuration;

    public WriteCsvSwitchoutService(MapWriter writer, PrebillingConfiguration configuration) {
        this.writer = writer;
        this.configuration = configuration;
    }

    @Override
    public void write(MisuraPod misuraPod) {
        String codicePod = misuraPod.getCodicePod();
        PrebillingContext.setContext(this.getClass().getSimpleName(), "pod: " + codicePod);
        boolean attiva = misuraPod.hasAttiva();
        boolean reattiva = misuraPod.hasReattiva();
        boolean potenza = misuraPod.hasPotenza();
        boolean commerciale = misuraPod.getMisura().hasCommerciale();
        Date dataMisura = misuraPod.getDataMisura();
        this.writer.print(codicePod, codicePod, "");
        this.writer.print(codicePod, ";", "");
        this.writer.print(codicePod, ";", "");
        this.writer.print(codicePod, DATE_FORMAT.format(dataMisura), "");
        this.writer.print(codicePod, ";", "");
        this.writer.print(codicePod, attiva ? "1" : "0", "");
        this.writer.print(codicePod, ";", "");
        this.writer.print(codicePod, reattiva ? "1" : "0", "");
        this.writer.print(codicePod, ";", "");
        this.writer.print(codicePod, potenza ? "1" : "0", "");
        this.writer.print(codicePod, ";", "");
        this.writer.print(codicePod, ";", "");
        this.writer.print(codicePod, commerciale ? "3" : "", "");
        this.writer.print(codicePod, ";", "");
        Trattamento trattamento = misuraPod.getTrattamento();
        this.printAttiva(codicePod, misuraPod, trattamento);
        this.printReattiva(codicePod, misuraPod, reattiva, trattamento);
        this.printPotenza(codicePod, misuraPod, potenza, trattamento);
        this.writer.print(codicePod, ";", "");
        this.writer.print(codicePod, ";", "");
        this.writer.print(codicePod, ";", "");
        this.writer.print(codicePod, ";", "");
        double ka = misuraPod.getKa().doubleValue();
        this.printCommerciale(codicePod, misuraPod, ka);
        this.writer.print(codicePod, "*", "\n");
    }

    private void printCommerciale(String codicePod, MisuraPod misuraPod, double ka) {
        Misura misura = misuraPod.getMisura();
        if (misura.hasCommerciale()) {
            int nCifre = this.configuration.getNCifreAttiva(ka);
            double ecf1 = misura.getCommerciale(FasciaOraria.F1).getNetto();
            this.print(codicePod, ecf1, nCifre);
            this.writer.print(codicePod, ";", "");
            double ecf2 = misura.getCommerciale(FasciaOraria.F2).getNetto();
            this.print(codicePod, ecf2, nCifre);
            this.writer.print(codicePod, ";", "");
            double ecf3 = misura.getCommerciale(FasciaOraria.F3).getNetto();
            this.print(codicePod, ecf3, nCifre);
            this.writer.print(codicePod, ";", "");
            this.writer.print(codicePod, ";", "");
        } else {
            this.writer.print(codicePod, ";", "");
            this.writer.print(codicePod, ";", "");
            this.writer.print(codicePod, ";", "");
            this.writer.print(codicePod, ";", "");
        }
    }

    private void printPotenza(String codicePod, MisuraD65 misura, boolean potenza, Trattamento trattamento) {
        if (potenza) {
            double kp = misura.getKp().doubleValue();
            int nCifrePotenza = this.configuration.getNCifrePotenza(kp);
            if (trattamento.isMono()) {
                double pot = misura.getPotMValue();
                this.print(codicePod, pot, nCifrePotenza);
                this.writer.print(codicePod, ";", "");
                this.writer.print(codicePod, ";", "");
                this.writer.print(codicePod, ";", "");
            } else {
                double potF1 = misura.getPotF1Value();
                this.print(codicePod, potF1, nCifrePotenza);
                this.writer.print(codicePod, ";", "");
                double potF2 = misura.getPotF2Value();
                this.print(codicePod, potF2, nCifrePotenza);
                this.writer.print(codicePod, ";", "");
                double potF3 = misura.getPotF3Value();
                this.print(codicePod, potF3, nCifrePotenza);
                this.writer.print(codicePod, ";", "");
            }
        } else {
            this.writer.print(codicePod, ";", "");
            this.writer.print(codicePod, ";", "");
            this.writer.print(codicePod, ";", "");
        }
        this.writer.print(codicePod, ";", "");
    }

    private void printReattiva(String codicePod, MisuraD65 misura, boolean reattiva, Trattamento trattamento) {
        if (reattiva) {
            double kr = misura.getKr().doubleValue();
            int nCifre = this.configuration.getNCifreReattiva(kr);
            if (trattamento.isMono()) {
                this.writer.print(codicePod, ";", "");
                this.writer.print(codicePod, ";", "");
                double erf1 = misura.getERMDouble();
                this.print(codicePod, erf1, nCifre);
                this.writer.print(codicePod, ";", "");
            } else {
                double erf1 = misura.getERF1Double();
                this.print(codicePod, erf1, nCifre);
                this.writer.print(codicePod, ";", "");
                double erf2 = misura.getERF2Double();
                this.print(codicePod, erf2, nCifre);
                this.writer.print(codicePod, ";", "");
                double erf3 = misura.getERF3Double();
                this.print(codicePod, erf3, nCifre);
                this.writer.print(codicePod, ";", "");
            }
        } else {
            this.writer.print(codicePod, ";", "");
            this.writer.print(codicePod, ";", "");
            this.writer.print(codicePod, ";", "");
        }
        this.writer.print(codicePod, ";", "");
    }

    private void printAttiva(String codicePod, MisuraD65 misura, Trattamento trattamento) {
        double ka = misura.getKa().doubleValue();
        int nCifre = this.configuration.getNCifreAttiva(ka);
        if (trattamento.isMono()) {
            this.writer.print(codicePod, "1", "");
            this.writer.print(codicePod, ";", "");
            double eam = misura.getEAMDouble();
            this.print(codicePod, eam, nCifre);
            this.writer.print(codicePod, ";", "");
            this.writer.print(codicePod, ";", "");
            this.writer.print(codicePod, ";", "");
        } else {
            this.writer.print(codicePod, misura.isForfait() ? "1" : "3", "");
            this.writer.print(codicePod, ";", "");
            double eaf1 = misura.getEAF1Double();
            this.print(codicePod, eaf1, nCifre);
            this.writer.print(codicePod, ";", "");
            if (misura.isForfait()) {
                this.writer.print(codicePod, ";", "");
            } else {
                double eaf2 = misura.getEAF2Double();
                this.print(codicePod, eaf2, nCifre);
                this.writer.print(codicePod, ";", "");
                double eaf3 = misura.getEAF3Double();
                this.print(codicePod, eaf3, nCifre);
            }
            this.writer.print(codicePod, ";", "");
        }
        this.writer.print(codicePod, ";", "");
    }

    private void print(String codicePod, double energy, int nCifre) {
        double value = this.configuration.isTrunking() ? MathUtils.floor(energy, nCifre) : energy;
        this.writer.print(codicePod, DOUBLE_EXPORT_FORMAT.format(value), "");
    }
}

