/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.AbstractBasicTPManager;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import java.text.DateFormat;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;

class VT4TPManager
extends AbstractBasicTPManager {
    VT4TPManager() {
    }

    @Override
    public boolean check(Date dataPratica, Date timeout) {
        return true;
    }

    @Override
    public Mno getMno(Pod pod, Pratica pratica, int scostamento, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        Mno mno;
        Date dataPratica = pratica.getSpecificaTecnica().getData();
        String codicePod = pod.getCodice();
        try {
            mno = this.getMisuraPraticaTardiva(codicePod, dataPratica, scostamento, E_TIPI_DATO, handler, misureDao);
        }
        catch (DataNotFoundException exc) {
            mno = this.getMisuraPraticaTardiva(codicePod, dataPratica, scostamento, ALL_TIPI_DATO, handler, misureDao);
        }
        Date requested = CalendarTools.previousDay(dataPratica);
        mno.setDataMisura(requested);
        return mno;
    }

    @Override
    public Mno getMno(Pod pod, Pratica pratica, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        Mno mno;
        Date dataPratica = pratica.getSpecificaTecnica().getData();
        String codicePod = pod.getCodice();
        try {
            mno = this.getMisuraPraticaTardiva(codicePod, dataPratica, 0, E_TIPI_DATO, handler, misureDao);
            VT4TPManager.checkDate(mno, dataPratica);
        }
        catch (DataNotFoundException exc) {
            Date requested = CalendarTools.previousDay(dataPratica);
            mno = this.getMisuraPraticaTardiva(codicePod, requested, 0, ALL_TIPI_DATO, handler, misureDao);
            VT4TPManager.checkDate(mno, requested);
        }
        return mno;
    }

    private static void checkDate(Mno mno, Date requested) throws DataNotFoundException {
        Date dataMisura = mno.getDataMisura();
        if (!dataMisura.equals(requested)) {
            DateFormat dataFormat = StrategyHelper.getDataFormat();
            String codicePod = mno.getCodicePod();
            String key = String.valueOf(codicePod) + "|" + dataFormat.format(requested);
            throw new DataNotFoundException("pno.notfound", key);
        }
    }
}

