/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraPdo;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.common.AbstractVTTPManager;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.common.statopod.AbstractStatoPodHandler;
import biz.elabor.prebilling.services.letture.statopod.SwitchoutStatoPodBuilder;
import biz.elabor.prebilling.web.letture.SpecificaPrestazione;
import java.util.Date;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

class VT3TPManager
extends AbstractVTTPManager {
    VT3TPManager() {
    }

    @Override
    public boolean checkTardivo(Date dataPratica, Date timeout, boolean azzeramento) {
        return !azzeramento && super.checkTardivo(dataPratica, timeout, azzeramento);
    }

    @Override
    public <T extends MisuraPod> AbstractStatoPodHandler<T> getStatoPodHandler(SwitchoutStatoPodBuilder<T> builder) {
        return builder.buildVT3();
    }

    @Override
    public SpecificaPrestazione getSpecificaPrestazione(TipoPrestazione tipoPrestazione, Map<String, SpecificaPrestazione> specifiche) {
        return specifiche.get("VT3");
    }

    @Override
    public void handlePrestazioneTardiva(Funzionalita funzionalita, TipoPrestazione tipoPrestazione, String destinazione, Pod pod, Pratica pratica, Mno mno, StatusTransaction transaction, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) throws DataNotFoundException {
        this.handleSwitchout(tipoPrestazione, pod, pratica, mno, transaction, misureDao, configuration);
        VT3TPManager.handleD65(funzionalita, tipoPrestazione, destinazione, pod, pratica, mno, transaction, configuration, talkManager);
    }

    @Override
    public void handlePrestazioneTardiva(TipoPrestazione tipoPrestazione, boolean crm, Pod pod, Pratica pratica, Pdo pdo, StatusTransaction transaction, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) throws DataNotFoundException {
        SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
        Date dataPratica = specificaTecnica.getData();
        Misura misura = new Misura(dataPratica, true, 3, "VNO");
        misura.addId("0");
        MisuraPdo misuraPdo = new MisuraPdo(pod, pdo, misura);
        VT3TPManager.handleSwitchout(tipoPrestazione, pratica, misuraPdo, transaction, misureDao, configuration);
    }
}

