/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.statopod.AbstractBasicStatoPod;
import biz.elabor.prebilling.model.statopod.Prestazione;
import biz.elabor.prebilling.model.statopod.StatoPod;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.common.VPStatoPod;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.ReferenceHandler;
import biz.elabor.prebilling.services.common.statopod.StatoPodChecker;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.volture.AbstractVolturaSPH;
import java.util.Date;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;

public class VPStatoPodHandler
extends AbstractVolturaSPH {
    public VPStatoPodHandler(MisureDao misureDao) {
        super(misureDao);
    }

    @Override
    public void handleStato(MisuraPod current, String codicePrestazione, String codicePratica, StatusTransaction transaction, ReferenceHandler<MisuraPod> referenceHandler) throws StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException, DataNotFoundException {
        Date dataMisura = current.getDataMisura();
        Date dataMovimento = CalendarTools.nextDay(dataMisura);
        this.handleStato(current, codicePrestazione, codicePratica, dataMovimento, dataMisura, transaction, referenceHandler);
    }

    @Override
    public void handleStato(MisuraPod current, String codicePrestazione, String flusso, String codicePratica, Date dataMovimento, Date dataMisura, String idMovimento, StatusTransaction transaction, StatoPodChecker<MisuraPod> checker, ReferenceHandler<MisuraPod> referenceHandler) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        String codicePod = current.getCodicePod();
        int nuprogre = this.getNuprogre(codicePod, dataMisura, referenceHandler);
        this.handleStato(current, codicePrestazione, flusso, codicePratica, dataMovimento, dataMisura, idMovimento, transaction, checker, nuprogre, referenceHandler);
    }

    @Override
    protected Date getDataVoltura(MisuraPod current) {
        return current.getDataMisura();
    }

    @Override
    public AbstractBasicStatoPod buildStatoPod(Prestazione prestazione, String flusso, String cpGestore, String cpUtente, MisuraPod current, StatoPod riferimento, Date dataMovimento, String idMovimento, int nuprogre) {
        Pod pod = current.getPod();
        double[] lastAttiva = pod == null ? null : pod.getLastAttiva();
        double[] lastReattiva = pod == null ? null : pod.getLastReattiva();
        Date dataVoltura = this.getDataVoltura(current);
        return new VPStatoPod(prestazione, flusso, current, lastAttiva, lastReattiva, riferimento, nuprogre, dataVoltura);
    }
}

