/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.Funzionalita;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.misure.MisuraPdo;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.common.COFTPManager;
import biz.elabor.prebilling.services.common.PraticaTardivaHandler;
import biz.elabor.prebilling.services.common.SE3RC1TPManager;
import biz.elabor.prebilling.services.common.TipoPrestazioneManager;
import biz.elabor.prebilling.services.common.VPTPManager;
import biz.elabor.prebilling.services.common.VT1_3TPManager;
import biz.elabor.prebilling.services.common.VT1_4TPManager;
import biz.elabor.prebilling.services.common.VT3TPManager;
import biz.elabor.prebilling.services.common.VT4TPManager;
import biz.elabor.prebilling.services.common.statopod.AbstractStatoPodHandler;
import biz.elabor.prebilling.services.common.statopod.PraticaAnnullataException;
import biz.elabor.prebilling.services.common.statopod.StatoPodInvalidoException;
import biz.elabor.prebilling.services.common.statopod.StatoPodObsoletoException;
import biz.elabor.prebilling.services.letture.statopod.SwitchoutStatoPodBuilder;
import biz.elabor.prebilling.web.letture.SpecificaPrestazione;
import java.util.Date;
import java.util.Map;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public enum TipoPrestazione {
    COF(new COFTPManager()),
    VT3(new VT3TPManager()),
    VT4(new VT4TPManager()),
    SE3(new SE3RC1TPManager()),
    RC1(new SE3RC1TPManager()),
    DS1(new SE3RC1TPManager()),
    DS3(new SE3RC1TPManager()),
    VT1_3(new VT1_3TPManager()),
    VT1_4(new VT1_4TPManager()),
    VP1(new VPTPManager()),
    VP3(new VPTPManager());

    private final TipoPrestazioneManager manager;

    private TipoPrestazione(TipoPrestazioneManager manager) {
        this.manager = manager;
    }

    public static TipoPrestazione create(String name) {
        String fixed = "VT1".equals(name) ? "VT1_3" : name;
        return TipoPrestazione.valueOf(fixed);
    }

    public <T extends MisuraPod> AbstractStatoPodHandler<T> getStatoPodHandler(SwitchoutStatoPodBuilder<T> builder) {
        return this.manager.getStatoPodHandler(builder);
    }

    public void addSwitchOut(String destinazione, String codicePrestazione, MisuraPod misura, StatusTransaction transaction) {
        this.manager.addSwitchOut(destinazione, codicePrestazione, misura, transaction);
    }

    public void addMisuraOrariaPeriodo(MisuraPdo misuraPdo, StatusTransaction transaction) {
        this.manager.addMisuraOrariaPeriodo(misuraPdo, transaction);
    }

    public boolean check(Date dataPratica, Date timeout) {
        return this.manager.check(dataPratica, timeout);
    }

    public boolean checkTardivo(Date dataPratica, Date timeout, boolean azzeramento) {
        return this.manager.checkTardivo(dataPratica, timeout, azzeramento);
    }

    public Mno getMno(Pod pod, Pratica pratica, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        return this.manager.getMno(pod, pratica, handler, misureDao);
    }

    public Mno getMno(Pod pod, Pratica pratica, int scostamento, PraticaTardivaHandler handler, MisureDao misureDao) throws DataNotFoundException {
        return this.manager.getMno(pod, pratica, scostamento, handler, misureDao);
    }

    public SpecificaPrestazione getSpecificaPrestazione(Map<String, SpecificaPrestazione> specifiche) {
        return this.manager.getSpecificaPrestazione(this, specifiche);
    }

    public void handlePrestazioneTardiva(Funzionalita funzionalita, String destinazione, Pod pod, Pratica pratica, Mno mno, StatusTransaction transaction, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) throws DataNotFoundException, StatoPodInvalidoException, StatoPodObsoletoException, PraticaAnnullataException {
        this.manager.handlePrestazioneTardiva(funzionalita, this, destinazione, pod, pratica, mno, transaction, misureDao, configuration, talkManager);
    }

    public Pdo getPdo(Pod pod, Pratica pratica, int scostamento, MisureDao misureDao) {
        return this.manager.getPdo(pod, pratica, scostamento, misureDao);
    }

    public void handlePrestazioneTardiva(boolean crm, Pod pod, Pratica pratica, Pdo pdo, StatusTransaction transaction, MisureDao misureDao, PrebillingConfiguration configuration, TalkManager talkManager) throws DataNotFoundException {
        this.manager.handlePrestazioneTardiva(this, crm, pod, pratica, pdo, transaction, misureDao, configuration, talkManager);
    }
}

