/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.misure.model.WorkingPeriod;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.dao.MisureDao;
import biz.elabor.prebilling.model.ServiceStatus;
import biz.elabor.prebilling.model.calendar.CalendarioCommercialeHelper;
import biz.elabor.prebilling.model.giada.Pod;
import biz.elabor.prebilling.model.giada.Pratica;
import biz.elabor.prebilling.model.giada.PraticaVolo;
import biz.elabor.prebilling.model.giada.SpecificaTecnica;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.MisuraPdo;
import biz.elabor.prebilling.model.misure.MisuraPod;
import biz.elabor.prebilling.model.misure.Mno;
import biz.elabor.prebilling.model.misure.Pdo;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.prebilling.Reseller;
import biz.elabor.prebilling.model.statomisure.ErroriElaborazione;
import biz.elabor.prebilling.services.StatusTransaction;
import biz.elabor.prebilling.services.StrategyHelper;
import biz.elabor.prebilling.services.common.PnoSwitchoutSPB;
import biz.elabor.prebilling.services.common.SmisHandlingException;
import biz.elabor.prebilling.services.common.TipoPrestazione;
import biz.elabor.prebilling.services.common.statopod.AbstractStatoPodHandler;
import biz.elabor.prebilling.services.letture.MisuraHandler;
import biz.elabor.prebilling.services.letture.MisuraMno;
import biz.elabor.prebilling.services.letture.Pdo2GRMisuraHandler;
import biz.elabor.prebilling.services.letture.PnoMisuraHandler;
import biz.elabor.prebilling.services.letture.SwitchoutDeferredStatoPod;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.safe.SafeMap;

public class SwitchoutHelper {
    private static final List<String> PRESTAZIONI_SWITCHOUT = Arrays.asList("SE3", "VT4");
    private static final List<String> FLUSSI_ORARI_2G = Arrays.asList("PDO2G", "RFO2G");

    public static MisuraHandler getMisuraHandler(Mno mno, PrebillingConfiguration configuration, TalkManager talkManager) {
        String codiceFlusso = mno.getCodiceFlusso();
        MisuraHandler handler = FLUSSI_ORARI_2G.contains(codiceFlusso) ? new Pdo2GRMisuraHandler(configuration, talkManager) : new PnoMisuraHandler();
        return handler;
    }

    public static boolean checkSwitchOut(Pod pod, Mno mno, boolean checkOutDate) throws DataNotFoundException {
        Date endOfTime;
        Date dataMisura;
        boolean switchOut = false;
        Date switchOutDate = pod.getSwitchout();
        if (switchOutDate != null && (dataMisura = mno.getDataMisura()).before(endOfTime = CalendarTools.getEndOfTime())) {
            Date overflow = CalendarTools.nextDay(switchOutDate);
            if (dataMisura.after(overflow)) {
                if (checkOutDate) {
                    int error = ErroriElaborazione.DATA_MISURA_AFTER_SWITCHOUT.ordinal();
                    String codicePod = pod.getCodice();
                    throw new DataNotFoundException("datamisura.afterswitchout", codicePod, error);
                }
            } else {
                switchOut = !switchOutDate.after(dataMisura);
            }
        }
        return switchOut;
    }

    public static boolean addSwitchout(Pod pod, Mno mno, Date blockDate, StatusTransaction transaction, MisureDao misureDao, PrebillingConfiguration configuration) throws DataNotFoundException, SmisHandlingException {
        boolean handled;
        String codicePod = pod.getCodice();
        PraticaVolo pratica = StrategyHelper.getPiv(codicePod, null, transaction);
        boolean bl = handled = !pratica.isHandled();
        if (handled) {
            String codicePrestazione = pratica.getCodicePrestazione();
            SpecificaTecnica specificaTecnica = pratica.getSpecificaTecnica();
            Date dataPratica = specificaTecnica.getData();
            if (PRESTAZIONI_SWITCHOUT.contains(codicePrestazione) && blockDate.before(dataPratica)) {
                throw new SmisHandlingException(codicePod, codicePrestazione);
            }
            TipoPrestazione tipoPrestazione = TipoPrestazione.create(codicePrestazione);
            PnoSwitchoutSPB builder = new PnoSwitchoutSPB(misureDao);
            AbstractStatoPodHandler<MisuraPod> statoPodHandler = tipoPrestazione.getStatoPodHandler(builder);
            SwitchoutHelper.addSwitchout(tipoPrestazione, pratica, pod, mno, transaction, configuration, statoPodHandler);
            pratica.setHandled(true);
        }
        return handled;
    }

    public static void addSwitchout(TipoPrestazione tipoPrestazione, Pratica pratica, Pod pod, Mno mno, StatusTransaction transaction, PrebillingConfiguration configuration, AbstractStatoPodHandler<MisuraPod> statoPodHandler) throws DataNotFoundException {
        MisuraMno misuraMno = new MisuraMno(pod, mno);
        SwitchoutHelper.addSwitchout(tipoPrestazione, pratica, misuraMno, transaction, configuration, statoPodHandler);
    }

    public static void addSwitchout(TipoPrestazione tipoPrestazione, Date data, Pratica pratica, Pod pod, Pdo pdo, StatusTransaction transaction, AbstractStatoPodHandler<MisuraPdo> statoPodHandler, PrebillingConfiguration configuration) throws DataNotFoundException {
        boolean stimata = pdo.isStimata();
        RilMese rilMese = pdo.getRilMese();
        WorkingPeriod period = rilMese.getPeriod();
        Date startDate = period.getStartDate();
        String codiceOfferta = pod.getCodiceOfferta(startDate);
        boolean commerciale = CalendarioCommercialeHelper.isCommerciale(transaction, codiceOfferta, configuration);
        Misura misura = new Misura(data, stimata, 3, "PDO", "", commerciale, codiceOfferta);
        MisuraPdo misurapdo = new MisuraPdo(pod, pdo, misura);
        SwitchoutHelper.addSwitchout(tipoPrestazione, pratica, misurapdo, transaction, configuration, statoPodHandler);
    }

    public static <M extends MisuraPod> void addSwitchout(TipoPrestazione tipoPrestazione, Pratica pratica, M misura, StatusTransaction transaction, PrebillingConfiguration configuration, AbstractStatoPodHandler<M> statoPodHandler) throws DataNotFoundException {
        SafeMap<String, Reseller> resellers = transaction.getResellers();
        String azienda = pratica.getCodiceReseller();
        Reseller reseller = (Reseller)resellers.get(azienda);
        String codicePrestazione = pratica.getCodicePrestazione();
        String codiceFlusso = misura.getCodiceFlusso();
        ServiceStatus status = transaction.getStatus();
        String destinazione = StrategyHelper.getDestinazioneLate(configuration, codiceFlusso, azienda, codicePrestazione, status);
        if (reseller.isHandleStato()) {
            String codPratAtt = pratica.getCodPratAtt();
            SwitchoutDeferredStatoPod<M> defferedStatoPod = new SwitchoutDeferredStatoPod<M>(statoPodHandler, misura, codicePrestazione, codPratAtt);
            transaction.addDeferredStatoPod(defferedStatoPod);
        }
        tipoPrestazione.addSwitchOut(destinazione, codicePrestazione, misura, transaction);
        transaction.count(codicePrestazione);
    }
}

