/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.services.common;

import biz.elabor.misure.model.fasce.CalendarioFasceMensile;
import biz.elabor.prebilling.config.PrebillingConfiguration;
import biz.elabor.prebilling.model.calendar.CalendarMap;
import biz.elabor.prebilling.model.calendar.CalendarioCommercialeHelper;
import biz.elabor.prebilling.model.misure.Misura;
import biz.elabor.prebilling.model.misure.RilGiorno;
import biz.elabor.prebilling.model.misure.RilMese;
import biz.elabor.prebilling.model.misure.RilQuarto;
import biz.elabor.prebilling.services.CalendarNotFoundException;
import biz.elabor.prebilling.services.StatusTransaction;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;

public class MisuraAccumulator {
    private Iterator<RilGiorno> iterator;
    private RilGiorno rilGiorno;
    private CalendarioFasceMensile calComm;
    private ElaborCalendar expected;
    private String expectedFlusso;
    private String codiceOfferta;
    private final CalendarMap calendarMap;
    private final int anno;
    private final Month mese;
    private final PrebillingConfiguration configuration;
    private final CalendarioFasceMensile calArera;
    private int startIndex;

    public MisuraAccumulator(RilMese rilMese, CalendarMap calendarMap, PrebillingConfiguration configuration) throws CalendarNotFoundException {
        this.calendarMap = calendarMap;
        this.configuration = configuration;
        this.iterator = rilMese.iterator();
        this.next();
        this.anno = rilMese.getAnno();
        this.mese = rilMese.getMese();
        String idCalArera = this.configuration.getIdCalendarioArera();
        String codicePod = rilMese.getCodicePod();
        this.calArera = CalendarioCommercialeHelper.getCalendario(idCalArera, this.anno, this.mese, codicePod, calendarMap);
        this.expected = new ElaborCalendar(this.anno, this.mese, 1);
        this.expectedFlusso = this.rilGiorno == null ? null : this.rilGiorno.getFirstCodiceFlusso();
    }

    private void next() {
        if (this.iterator.hasNext()) {
            this.rilGiorno = this.iterator.next();
            this.startIndex = 0;
        } else {
            this.rilGiorno = null;
        }
    }

    public Misura buildMisuraRaw(boolean stimata, Date date) {
        boolean commerciale = this.calComm != null;
        String codiceFlusso = MisuraAccumulator.getCodiceFlusso(this.rilGiorno, this.startIndex);
        LinkedHashSet<String> id = new LinkedHashSet<String>();
        Misura misura = new Misura(null, stimata, 3, codiceFlusso, id, commerciale, this.codiceOfferta);
        while (this.rilGiorno != null) {
            Date expectedDate = this.expected.getDate();
            Date rilDate = this.rilGiorno.getDate();
            if (!rilDate.equals(expectedDate)) {
                Date misDate = misura.getDate();
                if (misDate == null) {
                    ElaborCalendar cal = new ElaborCalendar(rilDate);
                    cal.addGiorni(-1);
                    misDate = cal.getDate();
                    misura.setDate(misDate);
                }
                this.expected.setDate(rilDate);
                break;
            }
            if (rilDate.after(date)) {
                misura.setDate(date);
                break;
            }
            misura.setDate(rilDate);
            int index = misura.add(this.rilGiorno, this.startIndex, this.expectedFlusso, this.calArera, this.calComm);
            if (index < 100) {
                this.startIndex = index;
                RilQuarto rilQuarto = (RilQuarto)this.rilGiorno.get(index);
                misura.setCodiceFlusso(this.expectedFlusso);
                this.expectedFlusso = codiceFlusso = rilQuarto.getCodiceFlusso();
                break;
            }
            this.next();
            this.expected.addGiorni(1);
        }
        return misura;
    }

    private static String getCodiceFlusso(RilGiorno rilGiorno, int startIndex) {
        return rilGiorno == null ? null : rilGiorno.getCodiceFlusso(startIndex);
    }

    public void setOfferta(String codiceOfferta, String codicePod, StatusTransaction transaction) throws CalendarNotFoundException {
        String idCalComm = MisuraAccumulator.getIdCalendarioCommerciale(codiceOfferta, transaction);
        this.setOfferta(codiceOfferta, codicePod, idCalComm);
    }

    public void setOfferta(String codiceOfferta, String codicePod, String idCalComm) throws CalendarNotFoundException {
        this.codiceOfferta = codiceOfferta;
        String idCalArera = this.configuration.getIdCalendarioArera();
        try {
            this.calComm = idCalArera.equals(idCalComm) ? null : this.calendarMap.get(idCalComm, this.anno, this.mese);
        }
        catch (DataNotFoundException exc) {
            throw new CalendarNotFoundException(exc, codicePod);
        }
    }

    private static String getIdCalendarioCommerciale(String codiceOfferta, StatusTransaction transaction) {
        return CalendarioCommercialeHelper.getCalendarId(codiceOfferta, transaction);
    }

    public Date getExpectedDate() {
        return this.expected.getDate();
    }
}

